% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analytical_functions.R
\name{calc_min_dist_v}
\alias{calc_min_dist_v}
\title{Calculate minimum distance to lateral and end walls in a V-shaped
experimental tunnel}
\usage{
calc_min_dist_v(obj_name, simplify_output = TRUE)
}
\arguments{
\item{obj_name}{The input viewr object; a tibble or data.frame with attribute
\code{pathviewr_steps} that includes \code{"viewr"} and
\code{treatments_added}.}

\item{simplify_output}{If TRUE, the returned object includes only the minimum
distance between the subject and the lateral/end walls. If FALSE, the
returned object includes all variables internal to the calculation.}
}
\value{
A tibble or data.frame with added variables for
\code{height_2_vertex}, \code{height_2_screen}, \code{width_2_screen_pos},
\code{width_2_screen_neg}, \code{min_dist_pos}, \code{min_dist_neg},
\code{min_dist_end}, \code{bound_pos}, and \code{bound_neg}.
}
\description{
Calculate minimum distance to lateral and end walls in a V-shaped
experimental tunnel
}
\details{
For tunnels in which \code{vertex_angle} is >90 degree, \code{bound_pos}
and \code{bound_neg} represent a planes orthogonal to the lateral walls and
are used to modify \code{min_dist_pos} and \code{min_dist_neg} calculations
to prevent erroneous outputs.
\code{calc_min_dist_v()} assumes the subject locomotes facing forward,
therefore \code{min_dist_end} represents the minimum distance between the
subject and the end wall to which it is moving towards
All outputs are in meters.
}
\examples{
 ## Import sample data from package
motive_data <-
  read_motive_csv(system.file("extdata", "pathviewr_motive_example_data.csv",
                              package = 'pathviewr'))

 ## Process data up to and including insert_treatments()
motive_data_full <-
  motive_data \%>\%
  relabel_viewr_axes() \%>\%
  gather_tunnel_data() \%>\%
  trim_tunnel_outliers() \%>\%
  rotate_tunnel() \%>\%
  select_x_percent(desired_percent = 50) \%>\%
  separate_trajectories(max_frame_gap = "autodetect") \%>\%
  get_full_trajectories(span = 0.95) \%>\%
  insert_treatments(tunnel_config = "v",
                   perch_2_vertex = 0.4,
                   vertex_angle = 90,
                   tunnel_length = 2,
                   stim_param_lat_pos = 0.1,
                   stim_param_lat_neg = 0.1,
                   stim_param_end_pos = 0.3,
                   stim_param_end_neg = 0.3,
                   treatment = "lat10_end_30") \%>\%

 ## Now calculate the minimum distances to each wall
  calc_min_dist_v(simplify_output = TRUE)

  ## See 3 new variables for calculations to lateral and end walls
  names(motive_data_full)
}
\seealso{
Other mathematical functions: 
\code{\link{deg_2_rad}()},
\code{\link{find_curve_elbow}()},
\code{\link{get_2d_angle}()},
\code{\link{get_3d_angle}()},
\code{\link{get_3d_cross_prod}()},
\code{\link{get_dist_point_line}()},
\code{\link{get_velocity}()},
\code{\link{rad_2_deg}()}
}
\author{
Eric R. Press
}
\concept{mathematical functions}
