% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/split.R
\name{split_path}
\alias{split_path}
\alias{split_dir}
\title{Split a path into directory components}
\usage{
split_path(x = dir(), simplify = FALSE)

split_dir(x = ".", pattern = NULL, all.files = TRUE, recursive = TRUE,
  simplify = TRUE)
}
\arguments{
\item{x}{A character vector. For \code{split_path}, this should contain file 
paths, and it defaults to files in the current directory.  For 
\code{split_dir}, this should contain directory paths, and it defaults to
the current directory.}

\item{simplify}{A logical value. If \code{TRUE}, the return value is 
simplified from a list to a matrix.}

\item{pattern}{A string containing a regular expression, to filter the files
that are returned.  Passed to \code{\link[base]{dir}}.}

\item{all.files}{Logical. If \code{TRUE}, files whose name starts with a dot 
are included.  Passed to \code{\link[base]{dir}}.}

\item{recursive}{Logical. If \code{TRUE}, files in subdirectories are 
included.  Passed to \code{\link[base]{dir}}.}
}
\value{
Either a named list of character vectors containing the split paths,
or a matrix.  See \code{simplify} argument in Usage section.
}
\description{
\code{split_path} splits a character vector of paths into directory 
components.  The opposite of \code{\link[base]{file.path}}.
\code{split_dir} is a convenience wrapper equivalent to \code{dir} + 
\code{split_path}, making it easy to \code{\link[utils]{View}} directory 
contents.
}
\note{
Paths are split on forward and back slashes, except for double forward 
or back slashes at the start of (UNC) paths.  These are included in the first 
element of that split path.
}
\examples{
(splits <- split_path(c(getwd(), "~", r_home())))
# Reverse the operation
sapply(splits, paste, collapse = "/")

base_r_files <- split_dir(R.home(), pattern = "\\\\.R$")
\donttest{
  # Viewing not needed for testing purposes
  utils::View(base_r_files)
}
}
\seealso{
\code{\link[base]{file.path}}, \code{\link[base]{dir}}
}
