% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parent.R
\name{parent_dir}
\alias{parent_dir}
\title{Get the parent dir}
\usage{
parent_dir(x = ".", sep = c("/", "\\\\"))
}
\arguments{
\item{x}{A character vector of file paths.}

\item{sep}{String separator between directory levels in the output.}
}
\value{
A character vector of parent directories of the input.
}
\description{
Gets the parent directory of the input.
}
\note{
Missing values are returned as missing.  On Windows, the parent of a 
drive, e.g., \code{"c:/"} is itself.  Likewise, under Unix, the parent of 
\code{"/"} is itself.
}
\examples{
(x <- c(
  sys_which("R"),
  r_home(),
  r_profile_site(),
  "c:/",  # different behaviour under Windows/Unix
  "~",
  "/",
  "foo/bar/nonexistent",
  NA
))
parent_dir(x)
}
