% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{example_pathfindR_input}
\alias{example_pathfindR_input}
\title{Example Input for the pathfindR Enrichment Workflow - Rheumatoid Arthritis (H.sapiens)}
\format{
A data frame with 572 rows and 3 variables: \describe{
\item{Gene.symbol}{HGNC gene symbols of the differentially-expressed genes}
\item{logFC}{\ifelse{html}{\out{log<sub>2</sub>}}{\eqn{log_2}}(fold-change) values}
\item{adj.P.Val}{adjusted p values, via the Benjamini & Hochberg (1995) method}
}
}
\source{
\url{https://www.ncbi.nlm.nih.gov/geo/query/acc.cgi?acc=GSE15573}
}
\usage{
example_pathfindR_input
}
\description{
A dataset containing the differentially-expressed genes along with the
associated \ifelse{html}{\out{log<sub>2</sub>}}{\eqn{log_2}}(fold-change)
values and FDR adjusted p-values for the GEO dataset GSE15573. This microarray
dataset aimed to characterize gene expression profiles in the peripheral
blood mononuclear cells of 18 rheumatoid arthritis (RA) patients versus 15
healthy subjects. Differentially-expressed genes with adj.P.Val < 0.05 are
presented in this data frame.
\emph{Generated on Nov 1, 2019.}
}
\seealso{
\code{\link{example_pathfindR_output}} for the RA example pathfindR enrichment output
\code{\link{example_pathfindR_output_clustered}} for the RA example pathfindR clustering output
\code{\link{example_experiment_matrix}} for the RA differentially-expressed genes expression matrix
\code{\link[pathfindR]{run_pathfindR}} for details on the pathfindR enrichment analysis
}
\keyword{datasets}
