% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse_cdisc.R, R/parse_iso8601.R,
%   R/parse_to_parttime_matrix.R
\name{parse_cdisc_datetime}
\alias{parse_cdisc_datetime}
\alias{parse_iso8601_datetime}
\alias{parse_iso8601_datetime_as_timespan}
\alias{parse_to_parttime_matrix}
\title{Parse cdisc datetime strings as parttime matrix}
\usage{
parse_cdisc_datetime(x, warn = TRUE, ...)

parse_iso8601_datetime(x, warn = TRUE, ...)

parse_iso8601_datetime_as_timespan(x, ...)

parse_to_parttime_matrix(dates, regex = re_iso8601)
}
\arguments{
\item{x}{A \code{character} vector of iso8601 datetime strings}

\item{warn}{A \code{logical} indicating whether to warn when information
would be loss when coercing to a \code{parttime} matrix.}

\item{...}{Additional arguments unused}

\item{dates}{character vector of dates to parse for iso8601 components}

\item{regex}{A regular expression used for parsing parttime strings. Defaults
to a parser for the ISO8601 standard. Should include named capture groups
for each datetime field. See Details for more information.}
}
\value{
A matrix of capture fields discovered while parsing CDISC-style
datetimes.

A matrix of capture fields discovered while parsing ISO8601-style
datetimes.

A character matrix of capture fields provided by the provided regular
expression
}
\description{
Parse cdisc datetime strings as parttime matrix

Parse iso8601 datetime strings as parttime matrix

Parse iso8601 datetime strings as timespan array

Parse a character vector to create a matrix of datetime fields
}
\details{
A format regular expression should separate the components of a valid
datetime string, capturing strings which can be coerced to numeric values for
each of the nine datetime fields:

\itemize{
\item{\code{year}}
\item{\code{month}}
\item{\code{day}}
\item{\code{hour}}
\item{\code{min}}
\item{\code{sec}}
\item{\code{tzhour}}
}
}
\note{
A timespan array is an internal data structure used as the backend
representation of timespan objects. It consists of two parttime-like matrices
(with the addition of an "inclusive" column), one for the lower- and
upper-bounds of the timespan. Collectively, this amounts to a three
dimensional array.
}
\references{
\href{https://www.cdisc.org/system/files/members/standard/foundational/SDTMIG_v3.4.pdf}{CDISC SDTMIG v3.4}

\href{https://en.wikipedia.org/wiki/ISO_8601}{"ISO_8601" on Wikipedia}
}
\keyword{internal}
