% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pair_counting.R
\docType{methods}
\name{gammaStatistics}
\alias{gammaStatistics}
\alias{gammaStatistics,Partition,Partition-method}
\alias{gammaStatistics,PairCoefficients,missing-method}
\title{Gamma Statistics}
\usage{
gammaStatistics(p, q)

\S4method{gammaStatistics}{Partition,Partition}(p, q)

\S4method{gammaStatistics}{PairCoefficients,missing}(p, q = NULL)
}
\arguments{
\item{p}{The partition \eqn{P} or an instance of \linkS4class{PairCoefficients}}

\item{q}{The partition \eqn{Q} or NULL}
}
\description{
Compute the Gamma statistics
\deqn{\frac{N_{11}N_{00} - N_{10}N_{01}}{\sqrt{ N_{21}N_{12}N'_{10}N'_{01} }}}
}
\section{Methods (by class)}{
\itemize{
\item \code{p = Partition,q = Partition}: Compute given two partitions

\item \code{p = PairCoefficients,q = missing}: Compute given the pair coefficients
}}

\examples{
gammaStatistics(new("Partition", c(0, 0, 0, 1, 1)), 
                new("Partition", c(0, 0, 1, 1, 1))) == 1/6

}
\references{
\insertRef{Yule1900}{partitionComparison}
}
\author{
Fabian Ball \email{fabian.ball@kit.edu}
}
