% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/partitioners.R
\name{part_kmeans}
\alias{part_kmeans}
\title{Partitioner: K-means, ICC, scaled means}
\usage{
part_kmeans(algorithm = c("armadillo", "Hartigan-Wong", "Lloyd", "Forgy",
  "MacQueen"), search = c("binary", "linear"), init_k = NULL,
  n_hits = 4)
}
\arguments{
\item{algorithm}{The K-Means algorithm to use. The default is a fast version
of the LLoyd algorithm written in armadillo. The rest are options in
\code{\link[=kmeans]{kmeans()}}. In general, armadillo is fastest, but the other algorithms can
be faster in high dimensions.}

\item{search}{The search method. Binary search is generally more efficient
but linear search can be faster in very low dimensions.}

\item{init_k}{The initial k to test. If \code{NULL}, then the initial k is the
threshold times the number of variables.}

\item{n_hits}{In linear search method, the number of iterations that should
be under the threshold before reducing; useful for preventing false
positives.}
}
\value{
a \code{partitioner}
}
\description{
Partitioners are functions that tell the partition algorithm 1)
what to try to reduce 2) how to measure how much information is lost from
the reduction and 3) how to reduce the data. In partition, functions that
handle 1) are called directors, functions that handle 2) are called
metrics,  and functions that handle 3) are called reducers. partition has a
number of pre-specified partitioners for agglomerative data reduction.
Custom partitioners can be created with \code{\link[=as_partitioner]{as_partitioner()}}.

Pass \code{partitioner} objects to the \code{partitioner} argument of \code{\link[=partition]{partition()}}.

\code{part_kmeans()} uses the following direct-measure-reduce approach:
\itemize{
\item \strong{direct}: \code{direct_k_cluster()}, K-Means Clusters
\item \strong{measure}: \code{measure_min_icc()}, Minimum Intraclass Correlation
\item \strong{reduce}: \code{reduce_kmeans()}, Scaled Row Means
}
}
\examples{
set.seed(123)
df <- simulate_block_data(c(3, 4, 5), lower_corr = .4, upper_corr = .6, n = 100)

# fit partition using part_kmeans()
partition(df, threshold = .6, partitioner = part_kmeans())

}
\seealso{
Other partitioners: \code{\link{as_partitioner}},
  \code{\link{part_icc}}, \code{\link{part_minr2}},
  \code{\link{part_pc1}}, \code{\link{part_stdmi}},
  \code{\link{replace_partitioner}}
}
\concept{partitioners}
