% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/permutation.R
\name{summarize_partitions}
\alias{summarize_partitions}
\alias{map_permutations}
\title{Summarize and map partitions and permutations}
\usage{
summarize_partitions(.partition, .information)

map_permutations(.data, partitioner = part_icc(), ...,
  information = seq(0.1, 0.5, by = 0.1), nperm = 100)
}
\arguments{
\item{.data}{a data set to partition}

\item{partitioner}{the partitioner to use. The default is \code{\link[=part_icc]{part_icc()}}.}

\item{...}{arguments passed to \code{\link[=partition]{partition()}}}

\item{information}{a vector of minimum information to fit in \code{\link[=partition]{partition()}}}

\item{nperm}{Number of permuted data sets to test. Default is 100.}
}
\value{
a tibble
}
\description{
\code{summarize_partitions()} summarizes a \code{partition} and attaches it in a
\code{list-col}. \code{map_permutations()} processes \code{\link[=map_partition]{map_partition()}} for a set of
permuted data sets.
}
\keyword{internal}
