% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/field_force.R
\docType{data}
\name{field_force}
\alias{field_force}
\title{Apply a vector field to particles}
\description{
This force adjusts the velocity of particles based on a supplied vector
field. The vector field can either be specified using x and y velocities, or
angle and magnitude. Velocity adjustments are calculated based on a bilinear
interpolation.
}
\section{Training parameters}{

The following parameters defines the training of the force and can be passed
along a call to \code{\link[=wield]{wield()}}
\itemize{
\item \code{x} : A matrix giving the velocity in the x direction at each grid point
\item \code{y} : A matrix giving the velocity in the y direction at each grid point
\item \code{angle} : A matrix giving the direction of the velocity at each grid point.
Will only be considered if \code{x} and \code{y} are missing.
\item \code{vel} : A single numeric or a matrix of the same dimensions as \code{angle}
giving the magnitude of velocity at each grid point.
\item \code{xlim} : The coordinate span of the vector field in the x direction.
\item \code{ylim} : The coordinate span of the vector field in the y direction.
}
}

\seealso{
Other forces: 
\code{\link{center_force}},
\code{\link{collision_force}},
\code{\link{link_force}},
\code{\link{manybody_force}},
\code{\link{map_force}},
\code{\link{mean_force}},
\code{\link{random_force}},
\code{\link{reset_force}},
\code{\link{trap_force}},
\code{\link{x_force}},
\code{\link{y_force}}
}
\concept{forces}
\keyword{datasets}
