/*
 * Decompiled with CFR 0.152.
 */
package dsa;

import dsa.Hex;
import dsa.Interval;
import dsa.Node;
import dsa.NodeInfoComponent;
import dsa.NodeInfoModel;
import dsa.NodeTreeComponent;
import dsa.NodeTreeModel;
import dsa.NumericInterval;
import dsa.Partition;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

class SimpleTreeFrame
extends JFrame {
    private static Logger logger = Logger.getLogger(SimpleTreeFrame.class.getName());
    private static String OSNAME = System.getProperty("os.name");
    private static final int DEFAULT_WIDTH = 900;
    private static final int DEFAULT_HEIGHT = 900;
    private JTabbedPane tpane;
    private JLabel statusBar;
    File curdir = new File(System.getProperty("user.dir", "."));

    public SimpleTreeFrame(String[] args) {
        this.setTitle("SimpleTree");
        this.setSize(900, 900);
        JMenuBar menuBar = new JMenuBar();
        this.setJMenuBar(menuBar);
        JMenu fileMenu = new JMenu("File");
        menuBar.add(fileMenu);
        FileOpenAction openAction = new FileOpenAction();
        FileClearAction clearAction = new FileClearAction();
        FileCloseAction closeAction = new FileCloseAction();
        JMenuItem openItem = fileMenu.add(openAction);
        JMenuItem clearItem = fileMenu.add(clearAction);
        fileMenu.addSeparator();
        JMenuItem closeItem = fileMenu.add(closeAction);
        if (OSNAME.startsWith("Mac")) {
            openItem.setAccelerator(KeyStroke.getKeyStroke(79, 4));
            clearItem.setAccelerator(KeyStroke.getKeyStroke(76, 4));
            closeItem.setAccelerator(KeyStroke.getKeyStroke(87, 4));
        } else {
            openItem.setAccelerator(KeyStroke.getKeyStroke(79, 2));
            clearItem.setAccelerator(KeyStroke.getKeyStroke(76, 2));
            closeItem.setAccelerator(KeyStroke.getKeyStroke(87, 2));
            FileQuitAction quitAction = new FileQuitAction();
            JMenuItem quitItem = fileMenu.add(quitAction);
            quitItem.setAccelerator(KeyStroke.getKeyStroke(81, 2));
        }
        this.tpane = new JTabbedPane();
        this.tpane.setToolTipText("Open a partDSA visualization file using File -> Open menu");
        this.add((Component)this.tpane, "Center");
        this.statusBar = new JLabel(" ");
        this.add((Component)this.statusBar, "South");
        for (String arg : args) {
            File file = new File(arg);
            if (file.exists()) {
                try {
                    XMLStreamReader parser = this.getParser(file);
                    Map<String, String[]> factors = this.getFactors(parser);
                    List<Node> nodelist = this.mknode(parser);
                    JComponent contents = this.makeContents(nodelist);
                    this.tpane.addTab(file.getName(), null, contents);
                    this.tpane.setSelectedIndex(this.tpane.getTabCount() - 1);
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "error opening/processing data file " + file.getName(), e);
                    this.setStatus("error opening/processing data file");
                }
                continue;
            }
            logger.log(Level.WARNING, "file does not exist: " + file.getName());
        }
    }

    public void setStatus(String status) {
        this.statusBar.setText(status);
    }

    XMLStreamReader getParser(File fobj) {
        XMLStreamReader parser = null;
        try {
            FileInputStream in = new FileInputStream(fobj);
            XMLInputFactory factory = XMLInputFactory.newInstance();
            parser = factory.createXMLStreamReader(in);
        }
        catch (XMLStreamException xse) {
            logger.log(Level.WARNING, "unable to create XML parser", xse);
            this.setStatus("unable to create XML parser");
        }
        catch (FileNotFoundException fnfe) {
            logger.log(Level.WARNING, "unable to read data file", fnfe);
            this.setStatus("unable to read file: " + fobj.getPath());
        }
        return parser;
    }

    Map<String, String[]> getFactors(XMLStreamReader parser) {
        HashMap<String, String[]> factors = new HashMap<String, String[]>();
        if (parser != null) {
            try {
                String name = "FAKE";
                String varname = "FAKE";
                String type = "UNKNOWN";
                ArrayList<String> levels = null;
                boolean EOV = false;
                while (!EOV && parser.hasNext()) {
                    int event = parser.next();
                    switch (event) {
                        case 1: {
                            name = parser.getLocalName();
                            if (name.equals("variables")) break;
                            if (name.equals("variable")) {
                                varname = parser.getAttributeValue(null, "name");
                                type = parser.getAttributeValue(null, "type");
                                if (!type.equals("factor")) break;
                                levels = new ArrayList<String>();
                                break;
                            }
                            if (!name.equals("level")) break;
                            levels.add(parser.getAttributeValue(null, "name"));
                            break;
                        }
                        case 2: {
                            name = parser.getLocalName();
                            if (name.equals("variables")) {
                                EOV = true;
                                break;
                            }
                            if (!name.equals("variable") || !type.equals("factor")) break;
                            factors.put(varname, levels.toArray(new String[0]));
                            break;
                        }
                    }
                }
            }
            catch (XMLStreamException e) {
                logger.log(Level.WARNING, "error parsing XML file", e);
                this.setStatus("error parsing XML file");
            }
        }
        return factors;
    }

    List<Node> mknode(XMLStreamReader parser) {
        ArrayList<Node> nodelist = new ArrayList<Node>();
        if (parser != null) {
            try {
                double lower = Double.NEGATIVE_INFINITY;
                double upper = Double.POSITIVE_INFINITY;
                ArrayList<Partition> partlist = null;
                ArrayList<byte[]> blist = null;
                ImageIcon image = null;
                boolean needData = false;
                Partition partition = null;
                String partname = "UNKNOWN";
                String predictedValue = "UNKNOWN";
                String numobs = "UNKNOWN";
                String section = "UNKNOWN";
                String numsections = "UNKNOWN";
                String maxpartitions = "UNKNOWN";
                Interval[] intervalArray = new Interval[]{};
                ArrayList<NumericInterval> interlist = null;
                NumericInterval interval = null;
                String varname = "FAKE";
                String intervaltype = "UNKNOWN";
                boolean EOP = false;
                while (!EOP && parser.hasNext()) {
                    int event = parser.next();
                    switch (event) {
                        case 1: {
                            String name = parser.getLocalName();
                            if (name.equals("partlists")) break;
                            if (name.equals("partlist")) {
                                partlist = new ArrayList<Partition>();
                                break;
                            }
                            if (name.equals("partition")) {
                                interlist = new ArrayList<NumericInterval>();
                                partname = parser.getAttributeValue(null, "name");
                                numsections = parser.getAttributeValue(null, "numsections");
                                section = parser.getAttributeValue(null, "section");
                                predictedValue = parser.getAttributeValue(null, "predictedvalue");
                                numobs = parser.getAttributeValue(null, "numobs");
                                maxpartitions = parser.getAttributeValue(null, "max");
                                break;
                            }
                            if (name.equals("image")) {
                                blist = new ArrayList<byte[]>();
                                break;
                            }
                            if (name.equals("data")) {
                                needData = true;
                                break;
                            }
                            if (name.equals("interval")) {
                                varname = parser.getAttributeValue(null, "varname");
                                intervaltype = parser.getAttributeValue(null, "type");
                                lower = Double.NEGATIVE_INFINITY;
                                upper = Double.POSITIVE_INFINITY;
                                break;
                            }
                            if (!name.equals("range")) break;
                            String tmp = parser.getAttributeValue(null, "lower");
                            lower = tmp.equals("-Inf") ? Double.NEGATIVE_INFINITY : Double.parseDouble(tmp);
                            tmp = parser.getAttributeValue(null, "upper");
                            upper = tmp.equals("Inf") ? Double.POSITIVE_INFINITY : Double.parseDouble(tmp);
                            break;
                        }
                        case 2: {
                            String name = parser.getLocalName();
                            if (name.equals("partlists")) {
                                EOP = true;
                                break;
                            }
                            if (name.equals("partlist")) {
                                Node node = new Node(0, partlist);
                                node.splitup(node.getsplits());
                                nodelist.add(node);
                                break;
                            }
                            if (name.equals("partition")) {
                                partition = new Partition(partname, predictedValue, numobs, numsections, section, maxpartitions, image, interlist.toArray(intervalArray));
                                partlist.add(partition);
                                break;
                            }
                            if (name.equals("image")) {
                                logger.log(Level.FINE, "creating ImageIcon");
                                byte[] pngdata = this.concat(blist);
                                image = new ImageIcon(pngdata);
                                blist = null;
                                break;
                            }
                            if (name.equals("data")) {
                                needData = false;
                                break;
                            }
                            if (name.equals("interval")) {
                                interval = new NumericInterval(varname, lower, upper);
                                interlist.add(interval);
                                break;
                            }
                            if (!name.equals("range")) break;
                            break;
                        }
                        case 4: {
                            if (!needData) break;
                            String hexstr = parser.getText();
                            logger.log(Level.FINE, "decoding image data: " + hexstr);
                            blist.add(Hex.decodeHex(hexstr));
                            break;
                        }
                    }
                }
            }
            catch (XMLStreamException e) {
                logger.log(Level.WARNING, "error parsing XML file", e);
                this.setStatus("error parsing XML file");
            }
        }
        return nodelist;
    }

    private JComponent makeContents(List<Node> nodelist) {
        final NodeTreeModel model = new NodeTreeModel();
        TreeNode root = this.mktree(nodelist);
        final JTree tree = new JTree(root);
        tree.setRootVisible(true);
        tree.getSelectionModel().setSelectionMode(1);
        JScrollPane sp1 = new JScrollPane(tree);
        JPanel p1 = new JPanel();
        p1.setLayout(new BorderLayout());
        p1.add((Component)sp1, "Center");
        JLabel btitle = new JLabel("Node Browser");
        btitle.setToolTipText("Use this browser to select nodes for display below");
        btitle.setFont(new Font("SansSerif", 1, 20));
        btitle.setHorizontalAlignment(0);
        p1.add((Component)btitle, "North");
        String[] labels = Node.getLabels();
        String tooltip = "Select a node using the node browser above";
        final NodeInfoModel infomodel = new NodeInfoModel("Selected Node", tooltip, labels);
        NodeInfoComponent selectedNodePanel = new NodeInfoComponent(infomodel);
        JScrollPane sp2 = new JScrollPane(selectedNodePanel);
        JSplitPane split = new JSplitPane(0, p1, sp2);
        NodeTreeComponent nodetree = new NodeTreeComponent(model);
        JScrollPane sp3 = new JScrollPane(nodetree);
        tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                DefaultMutableTreeNode treenode = (DefaultMutableTreeNode)tree.getLastSelectedPathComponent();
                if (treenode == null) {
                    logger.log(Level.FINE, "selected path component is null");
                    return;
                }
                TreePath treepath = tree.getSelectionPath();
                if (treepath.getPathCount() < 2) {
                    logger.log(Level.FINE, "path count is less than two");
                    return;
                }
                DefaultMutableTreeNode toptreenode = (DefaultMutableTreeNode)treepath.getPathComponent(1);
                if (toptreenode == null) {
                    logger.log(Level.FINE, "second node in selected path is null");
                    return;
                }
                Object topnode = toptreenode.getUserObject();
                Object selected = treenode.getUserObject();
                if (topnode instanceof Node && selected instanceof Node) {
                    Node selectedNode = (Node)selected;
                    model.setNode((Node)topnode, selectedNode);
                    if (selectedNode.left == null) {
                        infomodel.update(selectedNode.getImage(), selectedNode.description());
                    } else {
                        infomodel.update(selectedNode.getImage(), new HashMap<String, String>());
                    }
                }
            }
        });
        return new JSplitPane(1, split, sp3);
    }

    byte[] concat(List<byte[]> blist) {
        int n = 0;
        for (byte[] b : blist) {
            n += b.length;
        }
        byte[] a = new byte[n];
        n = 0;
        for (byte[] b : blist) {
            System.arraycopy(b, 0, a, n, b.length);
            n += b.length;
        }
        return a;
    }

    TreeNode mktree(List<Node> nodelist) {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("Partitions");
        for (int i = 0; i < nodelist.size(); ++i) {
            Node node = nodelist.get(i);
            this.mktreeRecurse(root, node, i + 2);
        }
        return root;
    }

    void mktreeRecurse(DefaultMutableTreeNode parent, Node node, int maxpartitions) {
        MyMutableTreeNode t = new MyMutableTreeNode(node, maxpartitions);
        assert (parent != null);
        parent.add(t);
        if (node.left != null) {
            this.mktreeRecurse(t, node.left, maxpartitions);
        }
        if (node.right != null) {
            this.mktreeRecurse(t, node.right, maxpartitions);
        }
    }

    private class FileQuitAction
    extends AbstractAction {
        FileQuitAction() {
            super("Quit");
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            System.exit(0);
        }
    }

    private class FileClearAction
    extends AbstractAction {
        FileClearAction() {
            super("Clear Status");
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            SimpleTreeFrame.this.setStatus(" ");
        }
    }

    private class FileCloseAction
    extends AbstractAction {
        FileCloseAction() {
            super("Close Tab");
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            int selected = SimpleTreeFrame.this.tpane.getSelectedIndex();
            if (selected != -1) {
                logger.log(Level.FINE, "removing tab from SimpleTreeFrame");
                SimpleTreeFrame.this.tpane.remove(selected);
            }
        }
    }

    private class FileOpenAction
    extends AbstractAction {
        FileOpenAction() {
            super("Open...");
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            JFileChooser chooser = new JFileChooser(SimpleTreeFrame.this.curdir);
            int result = chooser.showOpenDialog(SimpleTreeFrame.this);
            if (result == 0) {
                SimpleTreeFrame.this.curdir = chooser.getCurrentDirectory();
                File file = chooser.getSelectedFile();
                logger.log(Level.FINE, "adding new tab to SimpleTreeFrame from file " + file.getPath());
                try {
                    XMLStreamReader parser = SimpleTreeFrame.this.getParser(file);
                    Map<String, String[]> factors = SimpleTreeFrame.this.getFactors(parser);
                    List<Node> nodelist = SimpleTreeFrame.this.mknode(parser);
                    JComponent contents = SimpleTreeFrame.this.makeContents(nodelist);
                    SimpleTreeFrame.this.tpane.addTab(file.getName(), null, contents);
                    SimpleTreeFrame.this.tpane.setSelectedIndex(SimpleTreeFrame.this.tpane.getTabCount() - 1);
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "error opening/processing data file " + file.getName(), e);
                    SimpleTreeFrame.this.setStatus("error opening/processing data file");
                }
            }
        }
    }

    private class MyMutableTreeNode
    extends DefaultMutableTreeNode {
        private Node node;
        private int maxpartitions;

        MyMutableTreeNode(Node node, int maxpartitions) {
            super(node);
            this.node = node;
            this.maxpartitions = maxpartitions;
        }

        @Override
        public String toString() {
            if (this.node.level == 0) {
                return String.format("Best of %d partitions", this.maxpartitions);
            }
            return this.node.toString();
        }
    }
}

