% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mendelianCheck.R
\name{mendelianCheck}
\alias{mendelianCheck}
\title{Check for Mendelian errors}
\usage{
mendelianCheck(x, remove = FALSE, verbose = !remove)
}
\arguments{
\item{x}{a \code{\link{linkdat}} object}

\item{remove}{a logical. If FALSE, the function returns the indices of
markers found to incorrect.  If TRUE, a new \code{linkdat} object is
returned, where the incorrect markers have been deleted.}

\item{verbose}{a logical. If TRUE, details of the markers failing the tests
are shown.}
}
\value{
A numeric containing the indices of the markers that did not pass the
tests, or (if \code{remove=TRUE}) a new \code{linkdat} object where the
failing markers are removed.
}
\description{
Check marker data for Mendelian inconsistencies
}
\examples{

x = nuclearPed(3)

# Adding a SNP with a mendelian error:
# Individual 3 has an allele 'c' not carried by either parents
m1 = marker(x, 1, c('a','a'), 2, c('a','b'), 3, c('a','c'))

# Another erroneous marker: The siblings carry more than 4 different alleles.
m2 = marker(x, 3, c(1,2), 4, c(3,4), 5, c(1,5))

# Another marker with incosistent genotypes among the siblings:
m3 = marker(x, 3, c(1,1), 4, c(2,2), 5, c(3,3))

# Another marker with incosistent genotypes among the siblings:
m4 = marker(x, 3, c(1,1), 4, c(2,3), 5, c(1,4))

# A correct marker (all homozygous for allele 'A')
m5 = marker(x, 1:5, 'A')

# An empty marker
m6 = marker(x)

x = setMarkers(x, list(m1,m2,m3,m4,m5,m6))

# Finding the errors
err_index = mendelianCheck(x, remove=FALSE)
stopifnot(all.equal(err_index, 1:4))

x_remove = mendelianCheck(x, remove=TRUE)
stopifnot(x_remove$nMark == 2)

}
