% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coefficient_anova.R
\name{coefficient_anova}
\alias{coefficient_anova}
\title{Compare coefficients of all shared predictors across models via ANOVA.}
\usage{
coefficient_anova(model_list, model_names = NULL, padj = p.adjust.methods)
}
\arguments{
\item{model_list}{A list of regression models.}

\item{model_names}{A list of names for the regression models (default is
\code{NULL}).}

\item{padj}{Adjustment of p-values for multiple comparisons. Value must come
from \code{\link{p.adjust.methods}}.}
}
\value{
Data frame of coefficient information. Data frame includes coefficient
 estimates for each model as well as results from ANOVA test comparing
 coefficients across models.
}
\description{
Compare coefficients of all shared predictors across models via ANOVA using
\code{\link{coef_welch}}.
}
\details{
For each predictor variable in the models, runs \code{\link{coef_welch}} to
test for equality of regression parameters across models.
}
\examples{
 states = as.data.frame(state.x77)

 m1 = lm(`Life Exp` ~ Income + Illiteracy, data=states,
         subset=state.region=='Northeast')
 m2 = lm(`Life Exp` ~ Income + Illiteracy, data=states,
         subset=state.region=='South')
 m3 = lm(`Life Exp` ~ Income + Illiteracy, data=states,
         subset=state.region=='North Central')
 m4 = lm(`Life Exp` ~ Income + Illiteracy, data=states,
         subset=state.region=='West')

 mList = list(m1, m2, m3, m4)

 coefficient_anova(model_list = mList,
                   model_names = c('Northeast', 'South',
                                   'North Central', 'West'))

}
\seealso{
\code{\link{coef_welch}}
}
