% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/split-data.R
\name{split_data_recurrent}
\alias{split_data_recurrent}
\title{Split data to obtain recurrent event data in PED format}
\usage{
split_data_recurrent(
  formula,
  data,
  transition = character(),
  cut = NULL,
  max_time = NULL,
  event = 1L,
  min_events = 1L,
  timescale = c("gap", "calendar"),
  ...
)
}
\arguments{
\item{formula}{A two sided formula with a \code{\link[survival]{Surv}} object
on the left-hand-side and covariate specification on the right-hand-side (RHS).
The RHS can be an extended formula, which specifies how TDCs should be transformed
using specials \code{concurrent} and \code{cumulative}. The left hand-side can
be in start-stop-notation. This, however, is only used to create left-truncated
data and does not support the full functionality.}

\item{data}{Either an object inheriting from data frame or in case of
time-dependent covariates a list of data frames (of length 2), where the first data frame
contains the time-to-event information and static covariates while the second
(and potentially further data frames) contain information on time-dependent
covariates and the times at which they have been observed.}

\item{transition}{A character indicating the column in data that indicates the
event/episode number for recurrent events.}

\item{cut}{Split points, used to partition the follow up into intervals.
If unspecified, all unique event times will be used.}

\item{max_time}{If \code{cut} is unspecified, this will be the last
possible event time. All event times after \code{max_time}
will be administratively censored at \code{max_time}.}

\item{event}{The value that encodes the occurrence of an event in the data set.}

\item{min_events}{Minimum number of events for each event number.}

\item{timescale}{Defines the timescale for the recurrent event data transformation.
Defaults to \code{"gaptime"}.}

\item{...}{Further arguments passed to the \code{data.frame} method and
eventually to \code{\link[survival]{survSplit}}}
}
\description{
Currently, the input data must be in start-stop notation for each spell and
contain a colum that indicates the spell (event number).
}
\examples{
data("veteran", package="survival")
head(veteran)
ped <- split_data(Surv(time, status)~trt + age, data=veteran,
   cut=c(0, 100, 400), id="id")
head(ped)
class(ped) # class ped (piece-wise exponential data)
}
\seealso{
\code{\link[survival]{survSplit}}
}
\keyword{internal}
