% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidyverse-methods.R
\name{dplyr_verbs}
\alias{dplyr_verbs}
\alias{arrange}
\alias{filter}
\alias{distinct_}
\alias{full_join}
\alias{group_by}
\alias{group_by_}
\alias{inner_join}
\alias{left_join}
\alias{mutate}
\alias{rename}
\alias{rename_}
\alias{right_join}
\alias{sample_frac}
\alias{sample_n}
\alias{select}
\alias{select_}
\alias{slice}
\alias{summarise}
\alias{transmute}
\alias{ungroup}
\alias{arrange.ped}
\alias{group_by.ped}
\alias{group_by_.ped}
\alias{ungroup.ped}
\alias{distinct_.ped}
\alias{filter.ped}
\alias{sample_n.ped}
\alias{sample_frac.ped}
\alias{slice.ped}
\alias{select.ped}
\alias{select_.ped}
\alias{mutate.ped}
\alias{rename.ped}
\alias{rename_.ped}
\alias{summarise.ped}
\alias{summarize.ped}
\alias{transmute.ped}
\alias{inner_join.ped}
\alias{full_join.ped}
\alias{left_join.ped}
\alias{right_join.ped}
\alias{arrange.nested_fdf}
\alias{group_by.nested_fdf}
\alias{group_by_.nested_fdf}
\alias{ungroup.nested_fdf}
\alias{distinct_.nested_fdf}
\alias{filter.nested_fdf}
\alias{sample_n.nested_fdf}
\alias{sample_frac.nested_fdf}
\alias{slice.nested_fdf}
\alias{select.nested_fdf}
\alias{select_.nested_fdf}
\alias{mutate.nested_fdf}
\alias{rename.nested_fdf}
\alias{rename_.nested_fdf}
\alias{summarise.nested_fdf}
\alias{summarize.nested_fdf}
\alias{transmute.nested_fdf}
\alias{inner_join.nested_fdf}
\alias{full_join.nested_fdf}
\alias{left_join.nested_fdf}
\alias{right_join.nested_fdf}
\title{\code{dplyr} Verbs for \code{ped}-Objects}
\usage{
\method{arrange}{ped}(.data, ...)

\method{group_by}{ped}(.data, ..., add = FALSE)

\method{group_by_}{ped}(.data, ..., .dots = list(), add = FALSE)

\method{ungroup}{ped}(x, ...)

\method{distinct_}{ped}(.data, ..., .dots = list())

\method{filter}{ped}(.data, ...)

\method{sample_n}{ped}(tbl, size, replace = FALSE, weight = NULL,
  .env = NULL, ...)

\method{sample_frac}{ped}(tbl, size = 1, replace = FALSE,
  weight = NULL, .env = NULL, ...)

\method{slice}{ped}(.data, ...)

\method{select}{ped}(.data, ...)

\method{select_}{ped}(.data, ..., .dots = list())

\method{mutate}{ped}(.data, ..., keep_attributes = TRUE)

\method{rename}{ped}(.data, ...)

\method{rename_}{ped}(.data, ..., .dots = list())

\method{summarise}{ped}(.data, ...)

\method{summarize}{ped}(.data, ...)

\method{transmute}{ped}(.data, ...)

\method{inner_join}{ped}(x, y, by = NULL, copy = FALSE,
  suffix = c(".x", ".y"), ...)

\method{full_join}{ped}(x, y, by = NULL, copy = FALSE,
  suffix = c(".x", ".y"), ...)

\method{left_join}{ped}(x, y, by = NULL, copy = FALSE,
  suffix = c(".x", ".y"), ..., keep_attributes = TRUE)

\method{right_join}{ped}(x, y, by = NULL, copy = FALSE,
  suffix = c(".x", ".y"), ..., keep_attributes = TRUE)

\method{arrange}{nested_fdf}(.data, ...)

\method{group_by}{nested_fdf}(.data, ..., add = FALSE)

\method{group_by_}{nested_fdf}(.data, ..., .dots = list(), add = FALSE)

\method{ungroup}{nested_fdf}(x, ...)

\method{distinct_}{nested_fdf}(.data, ..., .dots = list())

\method{filter}{nested_fdf}(.data, ...)

\method{sample_n}{nested_fdf}(tbl, size, replace = FALSE,
  weight = NULL, .env = NULL, ...)

\method{sample_frac}{nested_fdf}(tbl, size = 1, replace = FALSE,
  weight = NULL, .env = NULL, ...)

\method{slice}{nested_fdf}(.data, ...)

\method{select}{nested_fdf}(.data, ...)

\method{select_}{nested_fdf}(.data, ..., .dots = list())

\method{mutate}{nested_fdf}(.data, ..., keep_attributes = TRUE)

\method{rename}{nested_fdf}(.data, ...)

\method{rename_}{nested_fdf}(.data, ..., .dots = list())

\method{summarise}{nested_fdf}(.data, ...)

\method{summarize}{nested_fdf}(.data, ...)

\method{transmute}{nested_fdf}(.data, ...)

\method{inner_join}{nested_fdf}(x, y, by = NULL, copy = FALSE,
  suffix = c(".x", ".y"), ...)

\method{full_join}{nested_fdf}(x, y, by = NULL, copy = FALSE,
  suffix = c(".x", ".y"), ...)

\method{left_join}{nested_fdf}(x, y, by = NULL, copy = FALSE,
  suffix = c(".x", ".y"), ..., keep_attributes = TRUE)

\method{right_join}{nested_fdf}(x, y, by = NULL, copy = FALSE,
  suffix = c(".x", ".y"), ..., keep_attributes = TRUE)
}
\arguments{
\item{.data}{an  object of class \code{ped}, see \code{\link{as_ped}}.}

\item{...}{see \code{dplyr} documentation}

\item{add}{When \code{add = FALSE}, the default, \code{group_by()} will
override existing groups. To add to the existing groups, use
\code{add = TRUE}.}

\item{.dots}{see \code{dplyr} documentation}

\item{x}{an  object of class \code{ped}, see \code{\link{as_ped}}.}

\item{tbl}{an  object of class \code{ped}, see \code{\link{as_ped}}.}

\item{size}{For \code{sample_n()}, the number of rows to select.
For \code{sample_frac()}, the fraction of rows to select.
If \code{tbl} is grouped, \code{size} applies to each group.}

\item{replace}{Sample with or without replacement?}

\item{weight}{Sampling weights. This must evaluate to a vector of
non-negative numbers the same length as the input. Weights are
automatically standardised to sum to 1.

This argument is automatically \link[rlang:quo]{quoted} and later
\link[rlang:eval_tidy]{evaluated} in the context of the data
frame. It supports \link[rlang:quasiquotation]{unquoting}. See
\code{vignette("programming")} for an introduction to these concepts.}

\item{.env}{This variable is deprecated and no longer has any
effect. To evaluate \code{weight} in a particular context, you can
now unquote a \link[rlang:quosure]{quosure}.}

\item{keep_attributes}{conserve attributes? defaults to \code{TRUE}}

\item{y}{tbls to join}

\item{by}{a character vector of variables to join by.  If \code{NULL}, the
default, \code{*_join()} will do a natural join, using all variables with
common names across the two tables. A message lists the variables so
that you can check they're right (to suppress the message, simply
explicitly list the variables that you want to join).

To join by different variables on x and y use a named vector.
For example, \code{by = c("a" = "b")} will match \code{x.a} to
\code{y.b}.}

\item{copy}{If \code{x} and \code{y} are not from the same data source,
and \code{copy} is \code{TRUE}, then \code{y} will be copied into the
same src as \code{x}.  This allows you to join tables across srcs, but
it is a potentially expensive operation so you must opt into it.}

\item{suffix}{If there are non-joined duplicate variables in \code{x} and
\code{y}, these suffixes will be added to the output to disambiguate them.
Should be a character vector of length 2.}

\item{funs}{see \code{\link[dplyr]{summarize_all}}}

\item{keep_attributes}{conserve attributes? defaults to \code{TRUE}}
}
\value{
a modified \code{ped} object (except for \code{do})
}
\description{
See \code{dplyr} documentation of the respective functions for
  description and examples.
}
\keyword{internal}
