% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vollenweider.R
\name{vollenweider_modified}
\alias{vollenweider_modified}
\title{Vollenweider Model Modification}
\usage{
vollenweider_modified(model_result)
}
\arguments{
\item{model_result}{A list containing the model result (e.g. from vollenweider_generate_regression_ETR_II()).}
}
\value{
A modified model result as a list containing the following elements:
\itemize{
  \item \code{etr_type}: ETR Type based on the model result.
  \item \code{etr_regression_data}: Regression data with ETR predictions based on the fitted model.
  \item \code{residual_sum_of_squares}: Difference between observed and predicted ETR values, expressed as the sum of squared residuals.
  \item \code{root_mean_squared_error}: Difference between observed and predicted ETR values, expressed as the root mean squared error.
  \item \code{relative_root_mean_squared_error}: Difference between observed and predicted ETR values, expressed as the relative root mean squared error, normalized by the mean.
  \item \code{a}: Obtained parameter \code{a}, here equal to \code{etrmax_without_photoinhibition}.
  \item \code{b}: Obtained parameter \code{b}, transferred as \code{a}.
  \item \code{c}: Obtained parameter \code{c}, here transferred as \code{alpha}.
  \item \code{d}: Obtained parameter \code{d}, here transferred as \code{n}.
  \item \code{alpha}: The initial slope of the light curve.
  \item \code{beta}: Not available, here set to \code{NA_real_}.
  \item \code{etrmax_with_photoinhibition}: The maximum electron transport rate with photoinhibition, transferred as \code{popt}.
  \item \code{etrmax_without_photoinhibition}: The maximum electron transport rate without photoinhibition, transferred as \code{pmax}.
  \item \code{ik_with_photoinhibition}: PAR where the transition point from light limitation to light saturation is achieved taking photoinhibition into account, transferred as \code{iik}.
  \item \code{ik_without_photoinhibition}: PAR where the transition point from light limitation to light saturation is achieved not taking photoinhibition into account, transferred as \code{ik}.
  \item \code{im_with_photoinhibition}: The PAR at which the maximum electron transport rate is achieved by taking photoinhibition into account, determined using the regression data from the model.
  \item \code{w}: Not available, here set to \code{NA_real_}.
  \item \code{ib}: Transferred unchanged as \code{ib}.
  \item \code{etrmax_with_without_ratio}: Ratio of \code{etrmax_with_photoinhibition} to \code{etrmax_without_photoinhibition} and \code{ik_with_photoinhibition} to \code{ik_without_photoinhibition}.
}
}
\description{
This function adds parameters that were not originally included in the Vollenweider (1965) model, but were introduced by other models, and renames the parameters to a standardized one for all models.
}
\details{
A detailed documentation can be found under \url{https://github.com/biotoolbox/pam?tab=readme-ov-file#vollenweider_modified}
}
\examples{
path <- file.path(system.file("extdata", package = "pam"), "20240925.csv")
data <- read_dual_pam_data(path)

result <- vollenweider_generate_regression_ETR_II(data)
modified_result <- vollenweider_modified(result)

}
