% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/maps.R
\name{niccoli}
\alias{cubicl}
\alias{cubicyf}
\alias{isol}
\alias{linearl}
\alias{linearlhot}
\alias{niccoli}
\title{Matteo Niccoli's perceptually uniform colormaps}
\usage{
cubicyf(n)

isol(n)

cubicl(n)

linearl(n)

linearlhot(n)
}
\arguments{
\item{n}{Number of colors to return}
}
\value{
A vector of colors
}
\description{
These colormaps are intended by be more perceptually balanced than traditional
rainbow-like palettes.
}
\details{
\code{isol()}: Lab-based isoluminant rainbow with constant luminance L*=60.
Best choice for displaying interval data with external lighting.
best for displaying interval data with external lighting.
This is so as to allow the lighting to provide the shading to highlight
the details of interest. If lighting is combined with a colormap that
has its own luminance function associated - even as simple as a
linear increase this will confuse the viewer.

\code{linearl()}: Lab-based linear lightness rainbow.
A linear lightness modification of Matlab's 'hot' palette.
For interval data displayed without external lighting.
100% perceptual

\code{linlhot()}: Linear lightness modification of Matlab's hot color palette.
For interval data displayed without external lighting
100% perceptual

\code{cubicyf()}: Lab-based rainbow scheme with cubic-law luminance(default)
For interval data displayed without external lighting
100% perceptual

\code{cubicl()}: Lab-based rainbow scheme with cubic-law luminance
For interval data displayed without external lighting
Similar to cubicyf(), but has red at high end
(a modest deviation from 100% perceptual)
}
\examples{
pal.bands(cubicyf,cubicl,isol,linearl,linearlhot)
pal.test(cubicyf) # purple blue green
pal.test(cubicl) # purple blue green orange
# pal.test(isol) # magenta blue green red. Poor in green area.
# pal.test(linearl) # black blue green tan. Poor in black area.
# pal.test(linearlhot) # black red yellow

}
\author{
Palettes by Matteo Niccoli. R code by Kevin Wright.
}
\references{
Matteo Niccoli (2010).
Perceptually improved colormaps.
http://www.mathworks.com/matlabcentral/fileexchange/28982-perceptually-improved-colormaps
Color definitions from here:
http://www.mathworks.com/matlabcentral/fileexchange/28982-perceptually-improved-colormaps/content/pmkmp/pmkmp.m
https://mycarta.wordpress.com/2012/05/29/the-rainbow-is-dead-long-live-the-rainbow-series-outline/
}

