% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fourDateFunctions.R
\name{timeList2fourDate}
\alias{timeList2fourDate}
\alias{fourDateFunctions}
\alias{fourDate2timeList}
\title{Converting Datasets of Taxon Ranges in Intervals Between \code{timeList} format and \code{fourDate} format}
\usage{
timeList2fourDate(timeList)

fourDate2timeList(fourDate)
}
\arguments{
\item{timeList}{A list composed of two matrices with two columns each, the first
giving interval start and end date bounds, and the second giving taxon first and
last interval appearances in reference to the intervals listed in the first matrix.}

\item{fourDate}{A four column matrix where each row is a different taxon, the first two columns
are the lower and upper bounds on the time of first appearance for that taxon and the third
and fourth columns are respectively the lower and upper bounds on the time of last appearance
for that taxon, all in time before present.}
}
\value{
A converted data object, respective to the function applied.
}
\description{
Functions for manipulating data where the first and last appearances of taxa
are known from bounded intervals of time. The two main functions listed here
are for converting between (1)
a data structure consisting of a single 'flat' table where each taxon is listed as a
set of four dates (a \code{fourDate} data type), and (2) a list format where each taxon
is listed as its first and last intervals, with an associated table of age bounds for
the intervals referred to in the first table (referred to as a \code{timeList} data
structure by many \code{paleotree} functions).
}
\details{
\code{timeList2fourDate} is for converting from a \code{timeList} format to
a \code{fourDate} format. \code{fourDate2timeList} is for converting from
a \code{fourDate} format to a \code{timeList} format.
}
\examples{
# timeList object from the retiolinae dataset
data(retiolitinae)

str(retioRanges)

taxicDivDisc(retioRanges)

fourDateRet <- timeList2fourDate(retioRanges)

# total uncertainty in retio first and last appearances?
sum(
    (fourDateRet[,1] - fourDateRet[,2]) + 
    (fourDateRet[,3]-fourDateRet[,4])
    )

#convert back
newTimeList <- fourDate2timeList(fourDateRet)
taxicDivDisc(retioRanges)

}
\references{
See my recent blog post on temporal datasets in paleontology for some details:

\url{https://nemagraptus.blogspot.com/2015/02/how-do-we-treat-fossil-age-data-dates.html}
}
\seealso{
\code{\link{bin_timePaleoPhy}} and \code{\link{taxicDivDisc}} for common applications;
\code{\link{binTimeData}} for a simulation function for such data objects
}
\author{
David W. Bapst
}
