% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paleoDiv.R
\name{mk.sptab}
\alias{mk.sptab}
\title{Generate a taxon-range table based on an occurrence dataset.}
\usage{
mk.sptab(
  xx = NULL,
  taxa = xx$tna,
  earliest = xx$eag,
  latest = xx$lag,
  tax = NULL
)
}
\arguments{
\item{xx}{A data.frame() of occurrence records, containing at least the following columns: taxonomic name at level at which ranges are to be determined (e.g. species or genus), earliest possible age for each occurrence and latest possible age for each occurrence. If xx==NULL, then each column or vector must be specified individualy using the following parameters}

\item{taxa}{column/vector containing the taxonomic variable. Defaults to xx$tna}

\item{earliest}{column/vector containing the earliest age estimate. Defaults to xx$eag.}

\item{latest}{column/vector containing the latest age estimate. Defaults to xx$lag.}

\item{tax}{Optional. A single character string containing the taxon name, to be added as another column to the range table (useful for categorization, should several range tables be concatenated, e.g. using rbind()).}
}
\value{
A data.frame() containing the taxon names, the maximum and minimum age for each taxon, and (optionally) a column with the name of the higher-level taxon.
}
\description{
Generate a taxon-range table based on an occurrence dataset.
}
\examples{
pdb("Stegosauria")->Stegosauria
mk.sptab(Stegosauria)->sptab_Stegosauria
}
