% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sysreqsdocs.R
\name{sysreqs_check_installed}
\alias{sysreqs_check_installed}
\alias{sysreqs_fix_installed}
\title{Check if installed packages have all their system requirements}
\usage{
sysreqs_check_installed(packages = NULL, library = .libPaths()[1])
sysreqs_fix_installed(packages = NULL, library = .libPaths()[1])
}
\arguments{
\item{packages}{If not \code{NULL}, then only these packages are checked.
If a package in \code{packages} is not installed, then
pak throws a warning.}

\item{library}{Library or libraries to check.}
}
\value{
Data frame with a custom print and format method, and a
\code{pkg_sysreqs_check_result} class. Its columns are:
\itemize{
\item \code{system_package}: string, name of the required system package.
\item \code{installed}: logical, whether the system package is correctly
installed.
\item \code{packages}: list column of character vectors. The names of the
installed R packages that need this system package.
\item \code{pre_install}: list column of character vectors. Commands to run
before the installation of the the system package.
\item \code{post_install}: list column of character vectors. Commands to run
after the installation of the system package.
}

The data frame also have two attributes with additional data:
\itemize{
\item \code{sysreqs_records}: the raw system requirements records, and
\item \code{system_packages}: the list of the installed system packages.
}

\code{sysreqs_fix_packages()} returns the same value, but invisibly.
}
\description{
\code{sysreqs_check_installed()} checks if the system requirements of all
packages (or a subset of packages) are installed.

\code{sysreqs_fix_installed()} installs the missing system packages.
}
\details{
These functions use the \code{sysreqs_platform} configuration option,
see \eval{man_config_link("Configuration")}. Set this if
pak does not detect your platform correctly.
}
\examples{
\dontshow{if (Sys.getenv("IN_PKGDOWN") == "true" && Sys.info()[["sysname"]] == "Linux") (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# This only works on supported platforms
sysreqs_check_installed()
\dontshow{\}) # examplesIf}
}
\seealso{
Other system requirements functions: 
\code{\link{pkg_sysreqs}()},
\code{\link{sysreqs_db_list}()},
\code{\link{sysreqs_db_match}()},
\code{\link{sysreqs_db_update}()},
\code{\link{sysreqs_is_supported}()},
\code{\link{sysreqs_list_system_packages}()},
\code{\link{sysreqs_platforms}()}
}
\concept{system requirements functions}
