% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/repo.R
\name{repo_add}
\alias{repo_add}
\alias{repo_resolve}
\title{Add a new CRAN-like repository}
\usage{
repo_add(..., .list = NULL)

repo_resolve(spec)
}
\arguments{
\item{...}{Repository specifications, possibly named character vectors.
See details below.}

\item{.list}{List or character vector of repository specifications.
This argument is easier to use programmatically than \code{...}. See
details below.}

\item{spec}{Repository specification, a possibly named character
scalar.}
}
\value{
\code{repo_resolve()} returns a named character scalar, the URL
of the repository.
}
\description{
Add a new repository to the list of repositories that pak uses to
look for packages.
}
\details{
\code{repo_add()} adds new repositories. It resolves the specified
repositories using \code{repo_resolve()} and then modifies the \code{repos}
global option.

\code{repo_add()} only has an effect in the current R session. If you
want to keep your configuration between R sessions, then set the
\code{repos} option to the desired value in your user or project \code{.Rprofile}
file.
}
\section{Repository specifications}{
The format of a repository specification is a named or unnamed
character scalar. If the name is missing, pak adds a name
automatically. The repository named \code{CRAN} is the main CRAN repository,
but otherwise names are informational.

Currently supported repository specifications:
\itemize{
\item URL pointing to the root of the CRAN-like repository. Example:

\if{html}{\out{<div class="sourceCode">}}\preformatted{https://cloud.r-project.org
}\if{html}{\out{</div>}}
\item \code{PPM@latest}, PPM (Posit Package Manager, formerly RStudio Package
Manager), the latest snapshot.
\item \verb{PPM@<date>}, PPM (Posit Package Manager, formerly RStudio Package
Manager) snapshot, at the specified date.
\item \verb{PPM@<package>-<version>} PPM snapshot, for the day after the
release of \verb{<version>} of \verb{<package>}.
\item \verb{PPM@R-<version>} PPM snapshot, for the day after R \verb{<version>}
was released.
}

Still works for dates starting from 2017-10-10, but now deprecated,
because MRAN is discontinued:
\itemize{
\item \verb{MRAN@<date>}, MRAN (Microsoft R Application Network) snapshot, at
the specified date.
\item \verb{MRAN@<package>-<version>} MRAN snapshot, for the
day after the release of \verb{<version>} of \verb{<package>}.
\item \verb{MRAN@R-<version>} MRAN snapshot, for the day
after R \verb{<version>} was released.
}

Notes:
\itemize{
\item See more about PPM at \url{https://packagemanager.posit.co/client/#/}.
\item The \verb{RSPM@} prefix is still supported and treated the same way as
\verb{PPM@}.
\item The MRAN service is now retired, see
\url{https://techcommunity.microsoft.com/t5/azure-sql-blog/microsoft-r-application-network-retirement/ba-p/3707161}
for details.
\item \code{MRAN@...} repository specifications now resolve to PPM, but note that
PPM snapshots are only available from 2017-10-10. See more about this
at \url{https://posit.co/blog/migrating-from-mran-to-posit-package-manager/}.
\item All dates (or times) can be specified in the ISO 8601 format.
\item If PPM does not have a snapshot available for a date, the next
available date is used.
\item Dates that are before the first, or after the last PPM snapshot
will trigger an error.
\item Unknown R or package versions will trigger an error.
}
}

\section{Examples}{


\if{html}{\out{<div class="sourceCode r">}}\preformatted{repo_add(PPMdplyr100 = "PPM@dplyr-1.0.0")
repo_get()
}\if{html}{\out{</div>}}\if{html}{\out{
<div class="asciicast" style="color: #172431;font-family: 'Fira Code',Monaco,Consolas,Menlo,'Bitstream Vera Sans Mono','Powerline Symbols',monospace;line-height: 1.300000"><pre>
#> <span style="color: #999999;"># A data frame: 7 × 5</span>                                                   
#>   name          url                         type  r_version bioc_version
#> <span style="color: #c2c2c2;">*</span> <span style="font-style: italic;color: #999999;">&lt;chr&gt;</span>         <span style="font-style: italic;color: #999999;">&lt;chr&gt;</span>                       <span style="font-style: italic;color: #999999;">&lt;chr&gt;</span> <span style="font-style: italic;color: #999999;">&lt;chr&gt;</span>     <span style="font-style: italic;color: #999999;">&lt;chr&gt;</span>       
#> <span style="color: #c2c2c2;">1</span> CRAN          https://cloud.r-project.org cran  *         <span style="color: #DC322F;">NA</span>          
#> <span style="color: #c2c2c2;">2</span> PPMdplyr100   https://packagemanager.pos… cran… *         <span style="color: #DC322F;">NA</span>          
#> <span style="color: #c2c2c2;">3</span> BioCsoft      https://bioconductor.org/p… bioc  4.3.1     3.17        
#> <span style="color: #c2c2c2;">4</span> BioCann       https://bioconductor.org/p… bioc  4.3.1     3.17        
#> <span style="color: #c2c2c2;">5</span> BioCexp       https://bioconductor.org/p… bioc  4.3.1     3.17        
#> <span style="color: #c2c2c2;">6</span> BioCworkflows https://bioconductor.org/p… bioc  4.3.1     3.17        
#> <span style="color: #c2c2c2;">7</span> BioCbooks     https://bioconductor.org/p… bioc  4.3.1     3.17        
</pre></div>
}}


\if{html}{\out{<div class="sourceCode r">}}\preformatted{repo_resolve("PPM@2020-01-21")
}\if{html}{\out{</div>}}\if{html}{\out{
<div class="asciicast" style="color: #172431;font-family: 'Fira Code',Monaco,Consolas,Menlo,'Bitstream Vera Sans Mono','Powerline Symbols',monospace;line-height: 1.300000"><pre>
#>                                       CRAN                              
#> "https://packagemanager.posit.co/cran/245"                              
</pre></div>
}}


\if{html}{\out{<div class="sourceCode r">}}\preformatted{repo_resolve("PPM@dplyr-1.0.0")
}\if{html}{\out{</div>}}\if{html}{\out{
<div class="asciicast" style="color: #172431;font-family: 'Fira Code',Monaco,Consolas,Menlo,'Bitstream Vera Sans Mono','Powerline Symbols',monospace;line-height: 1.300000"><pre>
#>                                       CRAN                              
#> "https://packagemanager.posit.co/cran/289"                              
</pre></div>
}}


\if{html}{\out{<div class="sourceCode r">}}\preformatted{repo_resolve("PPM@R-4.0.0")
}\if{html}{\out{</div>}}\if{html}{\out{
<div class="asciicast" style="color: #172431;font-family: 'Fira Code',Monaco,Consolas,Menlo,'Bitstream Vera Sans Mono','Powerline Symbols',monospace;line-height: 1.300000"><pre>
#>                                       CRAN                              
#> "https://packagemanager.posit.co/cran/276"                              
</pre></div>
}}
}

\seealso{
Other repository functions: 
\code{\link{repo_get}()},
\code{\link{repo_status}()}
}
\concept{repository functions}
