% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sysreqs.R
\name{pkg_sysreqs}
\alias{pkg_sysreqs}
\title{Calculate system requirements of one of more packages}
\usage{
pkg_sysreqs(pkg, upgrade = TRUE, dependencies = NA, sysreqs_platform = NULL)
}
\arguments{
\item{pkg}{Package names or package references. E.g.
\itemize{
\item \code{ggplot2}: package from CRAN, Bioconductor or a CRAN-like repository
in general,
\item \code{tidyverse/ggplot2}: package from GitHub,
\item \code{tidyverse/ggplot2@v3.4.0}: package from GitHub tag or branch,
\item \verb{https://examples.com/.../ggplot2_3.3.6.tar.gz}: package from URL,
\item \code{.}: package in the current working directory.
}

See "\link{Package sources}" for more details.}

\item{upgrade}{When \code{FALSE}, the default, pak does the minimum amount
of work to give you the latest version(s) of \code{pkg}. It will only upgrade
dependent packages if \code{pkg}, or one of their dependencies explicitly
require a higher version than what you currently have. It will also
prefer a binary package over to source package, even it the binary
package is older.

When \code{upgrade = TRUE}, pak will ensure that you have the latest
version(s) of \code{pkg} and all their dependencies.}

\item{dependencies}{What kinds of dependencies to install. Most commonly
one of the following values:
\itemize{
\item \code{NA}: only required (hard) dependencies,
\item \code{TRUE}: required dependencies plus optional and development
dependencies,
\item \code{FALSE}: do not install any dependencies. (You might end up with a
non-working package, and/or the installation might fail.)
See \link{Package dependency types} for other possible values and more
information about package dependencies.
}}

\item{sysreqs_platform}{System requirements platform. If \code{NULL}, then the
\code{sysreqs_platform} \eval{man_config_link("configuration option")}
is used, which defaults to the current platform. Set this option if
\eval{.packageName} does not detect your platform correctly.}
}
\value{
List with entries:
\itemize{
\item \code{os}: character string. Operating system.
\item \code{distribution}: character string. Linux distribution, \code{NA} if the
OS is not Linux.
\item \code{version}: character string. Distribution version, \code{NA} is the OS
is not Linux.
\item \code{pre_install}: character vector. Commands to run before the
installation of system packages.
\item \code{install_scripts}: character vector. Commands to run to install the
system packages.
\item \code{post_install}: character vector. Commands to run after the
installation of system packages.
\item \code{packages}: data frame. Information about the system packages that
are needed. It has columns:
\itemize{
\item \code{sysreq}: string, cross-platform name of the system requirement.
\item \code{packages}: list column of character vectors. The names of the R
packages that have this system requirement.
\item \code{pre_install}: list column of character vectors. Commands run
before the package installation for this system requirement.
\item \code{system_packages}: list column of character vectors. Names of
system packages to install.
\item \code{post_install}: list column of character vectors. Commands run
after the package installation for this system requirement.
}
}
}
\description{
Calculate system requirements of one of more packages
}
\seealso{
Other package functions: 
\code{\link{lib_status}()},
\code{\link{pak}()},
\code{\link{pkg_deps_tree}()},
\code{\link{pkg_deps}()},
\code{\link{pkg_download}()},
\code{\link{pkg_install}()},
\code{\link{pkg_remove}()},
\code{\link{pkg_status}()}

Other system requirements functions: 
\code{\link{sysreqs_check_installed}()},
\code{\link{sysreqs_db_list}()},
\code{\link{sysreqs_db_match}()},
\code{\link{sysreqs_db_update}()},
\code{\link{sysreqs_is_supported}()},
\code{\link{sysreqs_list_system_packages}()},
\code{\link{sysreqs_platforms}()}
}
\concept{package functions}
\concept{system requirements functions}
