% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docs.R
\name{FAQ}
\alias{FAQ}
\title{Frequently Asked Questions}
\description{
Please take a look at this list before asking questions.
}
\section{Package installation}{
\subsection{How do I reinstall a package?}{

pak does not reinstall a package, if the same version is already installed.
Sometimes you still want a reinstall, e.g. to fix a broken installation.
In this case you can delete the package and then install it, or use the
\code{?reinstall} parameter:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{pak::pkg_install("tibble")
}\if{html}{\out{</div>}}\if{html}{\out{
<div class="asciicast" style="color: #172431;font-family: 'Fira Code',Monaco,Consolas,Menlo,'Bitstream Vera Sans Mono','Powerline Symbols',monospace;line-height: 1.300000"><pre>
#>                                                                         
#> → Will <span style="font-style: italic;">install</span> 13 packages.                                             
#> → All 13 packages (7.68 MB) are cached.                                 
#> <span style="color: #525252;">+ </span><span style="color: #268BD2;">cli</span>         3.3.0                                                     
#> <span style="color: #525252;">+ </span><span style="color: #268BD2;">crayon</span>      1.5.1                                                     
#> <span style="color: #525252;">+ </span><span style="color: #268BD2;">ellipsis</span>    0.3.2                                                     
#> <span style="color: #525252;">+ </span><span style="color: #268BD2;">fansi</span>       1.0.3                                                     
#> <span style="color: #525252;">+ </span><span style="color: #268BD2;">glue</span>        1.6.2                                                     
#> <span style="color: #525252;">+ </span><span style="color: #268BD2;">lifecycle</span>   1.0.1                                                     
#> <span style="color: #525252;">+ </span><span style="color: #268BD2;">magrittr</span>    2.0.3                                                     
#> <span style="color: #525252;">+ </span><span style="color: #268BD2;">pillar</span>      1.7.0                                                     
#> <span style="color: #525252;">+ </span><span style="color: #268BD2;">pkgconfig</span>   2.0.3                                                     
#> <span style="color: #525252;">+ </span><span style="color: #268BD2;">rlang</span>       1.0.2                                                     
#> <span style="color: #525252;">+ </span><span style="color: #268BD2;">tibble</span>      3.1.7                                                     
#> <span style="color: #525252;">+ </span><span style="color: #268BD2;">utf8</span>        1.2.2                                                     
#> <span style="color: #525252;">+ </span><span style="color: #268BD2;">vctrs</span>       0.4.1                                                     
#> <span style="color: #2AA198;">ℹ</span> No downloads are needed, 13 pkgs (7.68 MB) are cached                 
#> <span style="color: #859900;">✔</span> Got <span style="color: #268BD2;">utf8</span> 1.2.2 (aarch64-apple-darwin20) (209.24 kB)                   
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">cli</span> 3.3.0  <span style="color: #a3a3a3;">(76ms)</span>                                           
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">crayon</span> 1.5.1  <span style="color: #a3a3a3;">(87ms)</span>                                        
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">ellipsis</span> 0.3.2  <span style="color: #a3a3a3;">(97ms)</span>                                      
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">fansi</span> 1.0.3  <span style="color: #a3a3a3;">(103ms)</span>                                        
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">glue</span> 1.6.2  <span style="color: #a3a3a3;">(111ms)</span>                                         
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">lifecycle</span> 1.0.1  <span style="color: #a3a3a3;">(153ms)</span>                                    
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">magrittr</span> 2.0.3  <span style="color: #a3a3a3;">(158ms)</span>                                     
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">pillar</span> 1.7.0  <span style="color: #a3a3a3;">(162ms)</span>                                       
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">pkgconfig</span> 2.0.3  <span style="color: #a3a3a3;">(87ms)</span>                                     
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">rlang</span> 1.0.2  <span style="color: #a3a3a3;">(39ms)</span>                                         
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">tibble</span> 3.1.7  <span style="color: #a3a3a3;">(41ms)</span>                                        
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">utf8</span> 1.2.2  <span style="color: #a3a3a3;">(39ms)</span>                                          
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">vctrs</span> 0.4.1  <span style="color: #a3a3a3;">(32ms)</span>                                         
#> <span style="color: #859900;">✔</span> 1 pkg + 12 deps: added 13, dld 1 (209.24 kB) <span style="color: #b8b8b8;">[1.8s]</span>                   
</pre></div>
}}


\if{html}{\out{<div class="sourceCode r">}}\preformatted{pak::pkg_install("tibble?reinstall")
}\if{html}{\out{</div>}}\if{html}{\out{
<div class="asciicast" style="color: #172431;font-family: 'Fira Code',Monaco,Consolas,Menlo,'Bitstream Vera Sans Mono','Powerline Symbols',monospace;line-height: 1.300000"><pre>
#>                                                                         
#> → Will <span style="font-style: italic;">install</span> 1 package.                                               
#> → The package (724.32 kB) is cached.                                    
#> <span style="color: #525252;">+ </span><span style="color: #268BD2;">tibble</span>   3.1.7                                                        
#> <span style="color: #2AA198;">ℹ</span> No downloads are needed, 1 pkg (724.32 kB) is cached                  
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">tibble</span> 3.1.7  <span style="color: #a3a3a3;">(42ms)</span>                                        
#> <span style="color: #859900;">✔</span> 1 pkg + 12 deps: kept 11, added 1 <span style="color: #b8b8b8;">[343ms]</span>                             
</pre></div>
}}

}

\subsection{How do I install a dependency from a binary package}{

Sometimes it is suffifient to install the binary package of an older
version of a dependency, instead of the newer source package that
potentially needs compilers, system tools or libraries.

\code{pkg_install()} and \code{lockfile_create()} default to \code{upgrade = FALSE}, which
always chooses binaries over source packages, so if you use \code{pkg_install()}
you don't need to do anything extra.

The \verb{local_install_*} functions default to \code{upgrade = TRUE}, as does \code{pak()}
with \code{pkf = NULL}, so for these you need to explicitly use \code{upgrade = FALSE}.
}

\subsection{How do I install a package from source?}{

To force the installation of a source package (instead of a binary
package), use the \code{?source} parameter:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{pak::pkg_install("tibble?source")
}\if{html}{\out{</div>}}\if{html}{\out{
<div class="asciicast" style="color: #172431;font-family: 'Fira Code',Monaco,Consolas,Menlo,'Bitstream Vera Sans Mono','Powerline Symbols',monospace;line-height: 1.300000"><pre>
#>                                                                         
#> → Will <span style="font-style: italic;">install</span> 1 package.                                               
#> → The package (672.34 kB) is cached.                                    
#> <span style="color: #525252;">+ </span><span style="color: #268BD2;">tibble</span>   3.1.7 👷🏼‍♀️🔧                                                 
#> <span style="color: #2AA198;">ℹ</span> No downloads are needed, 1 pkg (672.34 kB) is cached                  
#> <span style="color: #2AA198;">ℹ</span> Building <span style="color: #268BD2;">tibble</span> 3.1.7                                                 
#> <span style="color: #859900;">✔</span> Built <span style="color: #268BD2;">tibble</span> 3.1.7 <span style="color: #a3a3a3;">(3.1s)</span>                                             
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">tibble</span> 3.1.7  <span style="color: #a3a3a3;">(35ms)</span>                                        
#> <span style="color: #859900;">✔</span> 1 pkg + 12 deps: kept 11, added 1 <span style="color: #b8b8b8;">[4.1s]</span>                              
</pre></div>
}}

}

\subsection{How do I install the latest version of a dependency?}{

If you want to always install a dependency from source, because you want
the latest version or some other reason, you can use the \code{source}
parameter with the \verb{<package>=} form: \verb{<package>=?source}.
For example to install tibble, with its cli dependency installed from
source you could write:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{pak::pkg_install(c("tibble", "cli=?source"))
}\if{html}{\out{</div>}}\if{html}{\out{
<div class="asciicast" style="color: #172431;font-family: 'Fira Code',Monaco,Consolas,Menlo,'Bitstream Vera Sans Mono','Powerline Symbols',monospace;line-height: 1.300000"><pre>
#>                                                                         
#> → Will <span style="font-style: italic;">install</span> 1 package.                                               
#> → The package (540.04 kB) is cached.                                    
#> <span style="color: #525252;">+ </span><span style="color: #268BD2;">cli</span>   3.3.0 👷🏽🔧                                                       
#> <span style="color: #2AA198;">ℹ</span> No downloads are needed, 1 pkg (540.04 kB) is cached                  
#> <span style="color: #2AA198;">ℹ</span> Building <span style="color: #268BD2;">cli</span> 3.3.0                                                    
#> <span style="color: #859900;">✔</span> Built <span style="color: #268BD2;">cli</span> 3.3.0 <span style="color: #a3a3a3;">(4.5s)</span>                                                
#> <span style="color: #859900;">✔</span> Installed <span style="color: #268BD2;">cli</span> 3.3.0  <span style="color: #a3a3a3;">(68ms)</span>                                           
#> <span style="color: #859900;">✔</span> 1 pkg + 12 deps: kept 11, added 1 <span style="color: #b8b8b8;">[4.9s]</span>                              
</pre></div>
}}

}

\subsection{How do I ignore an optional dependency?}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{pak::pkg_install(
  c("tibble", "DiagrammeR=?ignore", "formattable=?ignore"),
  dependencies = TRUE
)
}\if{html}{\out{</div>}}\if{html}{\out{
<div class="asciicast" style="color: #172431;font-family: 'Fira Code',Monaco,Consolas,Menlo,'Bitstream Vera Sans Mono','Powerline Symbols',monospace;line-height: 1.300000"><pre>
#>                                                                         
#> <span style="color: #2AA198;">ℹ</span> No downloads are needed                                               
#> <span style="color: #859900;">✔</span> 1 pkg + 12 deps: kept 12 <span style="color: #b8b8b8;">[583ms]</span>                                      
</pre></div>
}}


The syntax is

\if{html}{\out{<div class="sourceCode">}}\preformatted{<packagename>=?ignore
}\if{html}{\out{</div>}}

Note that you can only ignore \emph{optional} dependencies, i.e. packages in
\code{Suggests} and \code{Enhances}.
}
}

\section{Others}{
\subsection{How can I use pak with renv?}{

You cannot currently, but keep on eye on this issue:
https://github.com/r-lib/pak/issues/343
}
}

