% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tools.R
\name{use_bsd2clause_license}
\alias{use_bsd2clause_license}
\title{Use the BSD-2-Clause License}
\usage{
use_bsd2clause_license(path = ".")
}
\arguments{
\item{path}{Path to the package directory (see
\code{\link[devtools:as.package]{devtools::as.package}}).}
}
\value{
Invisibly \code{\link{NULL}}.
}
\description{
It's my favorite and \pkg{devtools} provides
\code{\link[usethis:use_mit_license]{use_mit_license}} only.
}
\examples{
withr::with_dir(tempdir(),
                {
                    unlink("myPackage", recursive = TRUE)
                    usethis::create_package("myPackage", open = FALSE)
                    use_bsd2clause_license("myPackage")
                    list.files("myPackage")
                    grep("^License", readLines(file.path("myPackage",
                                                         "DESCRIPTION")))
                    readLines(file.path("myPackage", "LICENSE"))
                }
)
}
\keyword{internal}
