% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cran_downloads2.R
\name{plot.cranlogs}
\alias{plot.cranlogs}
\title{Plot method for cran_downloads2().}
\usage{
\method{plot}{cranlogs}(x, graphics_pkg = "ggplot2", points = TRUE,
  log_count = FALSE, smooth = FALSE, se = FALSE, f = 1/3, ...)
}
\arguments{
\item{x}{object.}

\item{graphics_pkg}{Character. "base" or "ggplot2".}

\item{points}{Logical. Plot points.}

\item{log_count}{Logical. Logarithm of package downloads.}

\item{smooth}{Logical. Add smoother.}

\item{se}{Logical. Works only with graphics_pkg = "ggplot2".}

\item{f}{Numeric. stats::lowess() smoother window. For use with graphics_pkg = "base" only.}

\item{...}{Additional plotting parameters.}
}
\value{
A base R or ggplot2 plot.
}
\description{
Plot method for cran_downloads2().
}
\examples{
\donttest{

plot(cran_downloads2(packages = c("Rcpp", "rlang", "data.table"), from = "2019-05-01",
  to = "2019-05-01"))
plot(cran_downloads2(packages = c("Rcpp", "rlang", "data.table"), when = "last-month"))
}
}
