% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1_model_functions.R
\name{markov_model}
\alias{markov_model}
\title{Definition of Markov model and trace}
\usage{
markov_model(
  current_strategy,
  cycles,
  initial_state,
  discount = c(0, 0),
  parameter_values = NULL,
  half_cycle_correction = TRUE,
  state_cost_only_prevalent = FALSE,
  state_util_only_prevalent = FALSE,
  method = "half cycle correction",
  startup_cost = NULL,
  startup_util = NULL
)
}
\arguments{
\item{current_strategy}{strategy object}

\item{cycles}{no of cycles}

\item{initial_state}{value of states initially}

\item{discount}{rate of discount for costs and qalys}

\item{parameter_values}{parameters for assigning health states and
probabilities}

\item{half_cycle_correction}{boolean to indicate half cycle correction}

\item{state_cost_only_prevalent}{boolean parameter to indicate if the costs
for state occupancy is only for those in the state excluding those that
transitioned new. This is relevant when the transition cost is provided for
eg. in a state with dialysis the cost of previous dialysis is different from
the newly dialysis cases. Then the state_cost_only_prevalent should be TRUE}

\item{state_util_only_prevalent}{boolean parameter to indicate if the
utilities for state occupancy is only for those in the state excluding
those that transitioned new.}

\item{method}{what type of half cycle correction needed}

\item{startup_cost}{cost of states initially}

\item{startup_util}{utility of states initially if any}
}
\value{
Markov trace
}
\description{
Definition of Markov model and trace
}
\details{
Use the strategy, cycles, initial state values creating the markov model
and trace. As many probabilities /cost/utility value depend on age/time the
evaluation and assignment happens during each cycle. At the heart it does
a matrix multiplication using the previous row of the trace matrix and the
columns of the transition matrix. Also checks for population loss, calculates
cumulative costs and qalys (accounts for discounting
and half cycle correction)
}
\examples{
tmat <- rbind(c(1, 2), c(3, 4))
colnames(tmat) <- rownames(tmat) <- c("Healthy", "Dead")
tm <- populate_transition_matrix(2, tmat, c(0.5, 0.5, 0, 1))
a <- health_state("Healthy", 1, 1, 0, FALSE)
b <- health_state("Dead", 1, 0, 0, TRUE)
health_states <- combine_state(a, b)
this.strategy <- strategy(tm, health_states, "intervention")
markov_model(this.strategy, 10, c(1, 0))
}
