% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/general_help_functions.R
\name{check_equal_columncontents_NAomitted}
\alias{check_equal_columncontents_NAomitted}
\title{Function to check the equality of column contents between two data sets
with omitting NA}
\usage{
check_equal_columncontents_NAomitted(
  data1,
  data2,
  samecol,
  column_data1,
  column_data2
)
}
\arguments{
\item{data1}{first data set}

\item{data2}{second data set}

\item{samecol}{a unique col in both datasets, like tno or id}

\item{column_data1}{column name in data 1 to be compared}

\item{column_data2}{column name in data 2 to be compared}
}
\value{
0 if they are equal else error message
}
\description{
Function to check the equality of column contents between two data sets
with omitting NA
}
\examples{
eg_data <- as.data.frame(list(no = c(1, 2, 3, 4),
mark_at_1 = c(12, 7, 23, 45), gender = c("M", "F", "M", "F"),
mark_at_2 = c(12, 34, 89, 45), trialarm = c("1","1","2","2"),
time = c(1,1,2,2), id = c(1, 1, 1, 2)))
eg_data2 <- as.data.frame(list(no = c(1, 2, 3, 4),
mark_at_1 = c(12, 27, 23, 45), gender = c("M", "F", "M", "F"),
mark_at_2 = c(12, 34, 89, 45), trialarm = c("1","1","2","2"),
time = c(1,1,2,2), id = c(1, 1, 1, 2)))
check_equal_columncontents_NAomitted(eg_data, eg_data2, "no",
"mark_at_1","mark_at_2")
}
