% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/2b_parameter_estimation_survival_functions.R
\name{use_coxph_survival}
\alias{use_coxph_survival}
\title{###########################################################################
Get the parameter values using the survival analysis using cox
proportional hazard}
\usage{
use_coxph_survival(
  param_to_be_estimated,
  dataset,
  indep_var,
  covariates,
  timevar_survival
)
}
\arguments{
\item{param_to_be_estimated}{parameter of interest}

\item{dataset}{data set to be provided}

\item{indep_var}{the independent variable (column name in data file)}

\item{covariates}{list of covariates - calculations to be done before passing}

\item{timevar_survival}{time variable for survival analysis, default is NA
false by default}
}
\value{
the results of the regression analysis
}
\description{
###########################################################################
Get the parameter values using the survival analysis using cox
proportional hazard
}
\details{
plots baseline cumulative hazard function, survival function for
each covariate
while keeping the other fixed at the mean value
(using plot_survival_cox_covariates),
survival function for each combination of covariate using survfit (using
plot_return_survival_curve) and test for cox regression results
It also returns  risk relative to mean (predicted at mean value
of each covariate) along with the fit results coefficients,
SE of coefficients, summary, and analysis of deviance
}
\examples{
\donttest{
data_for_survival <- survival::aml
surv_estimated <- use_coxph_survival("status", data_for_survival, "x",
  covariates = NA, "time")
}
\donttest{
data_for_survival <- survival::lung
surv_estimated <- use_coxph_survival("status", data_for_survival, "sex",
  covariates = c("ph.ecog"), "time")
}
}
