% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/3c_costing_resource_use_functions.R
\name{get_cost_AandE_code}
\alias{get_cost_AandE_code}
\title{Function to extract the unit hospital inpatient admission by
matching code}
\usage{
get_cost_AandE_code(
  code,
  type_admit,
  ref_cost_data_file,
  col_name_code,
  unit_cost_col,
  type_admit_col,
  sheet = NULL
)
}
\arguments{
\item{code}{code for AE attendance}

\item{type_admit}{term indicating admission and type of attendance}

\item{ref_cost_data_file}{file that has unit cost}

\item{col_name_code}{name of the column that has the code}

\item{unit_cost_col}{name of the column with the unit cost}

\item{type_admit_col}{colname that describes type of the attendance and
that indicates admitted or not}

\item{sheet}{sheet if excel file is given}
}
\value{
unit cost the unit cost matching the code
}
\description{
Function to extract the unit hospital inpatient admission by
matching code
}
\examples{
ref_cost_data_file <- system.file("extdata",
"National_schedule_of_NHS_costs_2019_AandE.csv", package = "packDAMipd")
re = get_cost_AandE_code("VB02Z", "T01A", ref_cost_data_file,
"Currency_Code","National_Average_Unit_Cost", "Service_Code")
}
