% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_line.R
\name{plot_line}
\alias{plot_line}
\alias{plot_line,Raster-method}
\alias{plot_line,data.table-method}
\alias{plot_line,character-method}
\title{Line ggplot}
\usage{
plot_line(x, var = "Precipitation", unit = "mm")

\S4method{plot_line}{Raster}(x, var = "Precipitation", unit = "mm")

\S4method{plot_line}{data.table}(x, var = "Precipitation", unit = "mm")

\S4method{plot_line}{character}(x, var = "Precipitation", unit = "mm")
}
\arguments{
\item{x}{Raster* object; data.table (see details); filename (character, see details)}

\item{var}{character (see details)}

\item{unit}{character (see details)}
}
\value{
ggplot object
}
\description{
Convenient and aesthetic visualization of data in a line plot.
}
\details{
If `x` is a data.table, its columns should be named: "lon", "lat", "date", and "value"

If `x` is a filename, it should point to a *.nc file.

`var` is a character string describing the variable to be used for the axis title

`unit` is a character string describing the unit of measurement to be used for the axis title
}
\examples{
\dontrun{
download_data("gldas-vic", tempdir(), timestep = "yearly")
r <- raster::brick(paste0(tempdir(),
"/gldas-vic_tp_mm_land_194801_201412_025_yearly.nc"))
s <- plot_line(r)
}
}
