% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pRecipe.R
\name{resample_data}
\alias{resample_data}
\title{Resampling precipitation data sets}
\usage{
resample_data(x, yearly = TRUE, resolution)
}
\arguments{
\item{x}{a pRecipe data.table imported using \code{\link{import_full_data}} or \code{\link{import_subset_data}}.}

\item{yearly}{logical. If TRUE (default) monthly data will be aggregated into yearly.}

\item{resolution}{numeric. Desired spatial resolution (original is 0.5)}
}
\value{
a data.table with the resampled data sets
}
\description{
The function \code{resample_data} resamples the imported data.
}
\examples{
\dontrun{
x <- import_full_data(c("cru_ts", "cpc", "ghcn", "gpcp"), tempdir())
y <- resample_data(x, yearly = FALSE, 5)
z <- resample_data(x, yearly = TRUE, 2.5)
}
}
