% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coef.R
\name{coef.Owl}
\alias{coef.Owl}
\title{Obtain coefficients}
\usage{
\method{coef}{Owl}(object, sigma = NULL, exact = FALSE, simplify = TRUE, ...)
}
\arguments{
\item{object}{an object of class \code{'Owl'}.}

\item{sigma}{penalty parameter for SLOPE models; if \code{NULL}, the
values used in the original fit will be used}

\item{exact}{if \code{TRUE} and the given parameter values differ from those in
the original fit, the model will be refit by calling \code{\link[stats:update]{stats::update()}} on
the object with the new parameters. If \code{FALSE}, the predicted values
will be based on interpolated coefficients from the original
penalty path.}

\item{simplify}{if \code{TRUE}, \code{\link[base:drop]{base::drop()}} will be called before returning
the coefficients to drop extraneous dimensions}

\item{...}{arguments that are passed on to \code{\link[stats:update]{stats::update()}} (and therefore
also to \code{\link[=owl]{owl()}}) if \code{exact = TRUE} and the given penalty
is not in \code{object}}
}
\value{
Coefficients from the model.
}
\description{
This function returns coefficients from a model fit by \code{\link[=owl]{owl()}}.
}
\details{
If \code{exact == FALSE} and \code{sigma} is not in \code{object},
then the returned coefficients will be approximated by linear interpolation.
If coefficients from another type of penalty sequence
(with a different \code{lambda}) are required, however,
please use \code{\link[=owl]{owl()}} to refit the model.
}
\examples{
fit <- owl(mtcars$mpg, mtcars$vs, n_sigma = 1)
coef(fit)
}
