% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outsider.R
\name{outsider-class}
\alias{outsider-class}
\alias{outsider_init}
\alias{outsider-methods}
\alias{run}
\alias{run.outsider}
\title{Construct outsider object}
\usage{
outsider_init(
  pkgnm,
  cmd = NA,
  arglist = NULL,
  wd = NULL,
  files_to_send = NULL,
  ignore_errors = FALSE
)

run(x, ...)

\method{run}{outsider}(x, ...)
}
\arguments{
\item{pkgnm}{Name of the installed R package for the outsider module}

\item{cmd}{Command to be called in the container}

\item{arglist}{Arguments for command, character vector}

\item{wd}{Directory to which program generated files will be returned}

\item{files_to_send}{Files to be sent to container}

\item{ignore_errors}{Ignore raised errors? Default FALSE.}

\item{x}{outsider object}

\item{...}{Additional arguments}
}
\value{
A list of class \code{outsider} with the following items:
\item{pkgnm}{Package name of the outsider module}
\item{cmd}{Command to be called in the container}
\item{arglist}{Arguments for command, character vector}
\item{wd}{Directory to which program generated files will be returned}
\item{files_to_send}{Files to be sent to container}
\item{container}{Docker container object}
\item{ignore_errors}{Prevent errors being raised}
}
\description{
Returns an outsider object. The outsider object describes a
outsider module's program and arguments. The object is generated every
time an outsider module program is called. It details the arguments of a
call, the command as well as the files to send to the docker container.
}
\details{
The outsider module runs a docker container that acts like a 
separate machine on the host computer. All the files necessary for the 
program to be run must be sent to the remote machine before the program
is called.
The arguments, wd and files_to_send can all be defined after the outsider
has been initiated using \code{$} notation.
Once a outsider has been defined, the command can be run using
\code{.run()}.
The \code{arglist}, \code{wd} or \code{files_to_send} do not need to be
defined for the outsider to be run.
}
\examples{
\donttest{
# Set-up: install "hello.world", ships with ubuntu
# we can make simple commands in bash via R using the module
library(outsider.base)

# Manually install example module
# outsider.base contains the hello.world module in its package files
pkgnm <- 'om..hello.world'
mdl_flpth <- system.file('extdata', 'om..hello.world',
                         package = "outsider.base")
# install and import (outsider::module_install performs these tasks)
pkg_install(flpth = mdl_flpth)
image_install(pkgnm = pkgnm)

# Run echo
# create a outsider object that contains argument and Docker container details
otsdr <- outsider_init(pkgnm = pkgnm, cmd = 'echo', arglist = c('hello world!'))
# check details
print(otsdr)
# run the command
run(otsdr)

# Send a file
# an existing outsider object can be modified
tmppth <- tempdir()
flpth <- file.path(tmppth, 'testfile')
write(x = 'hello from within a file!', file = flpth)
otsdr$files_to_send <- flpth
otsdr$cmd <- 'cat'
otsdr$arglist <- 'testfile'
# check details
print(otsdr)
# run the command
run(otsdr)

# Return a file
# an existing outsider object can be modified
otsdr$files_to_send <- NULL
otsdr$cmd <- 'touch'
otsdr$arglist <- 'newfile'
otsdr$wd <- tmppth  # determines where created files are returned to
# check details
print(otsdr)
# run the command
run(otsdr)
# check if 'newfile' exists in tempdir()
nwflpth <- file.path(tmppth, 'newfile')
(file.exists(nwflpth))

# Clean-up
rm(otsdr)
file.remove(flpth)
file.remove(nwflpth)
uninstall(pkgnm)
}
}
