% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/otp_get_times.R
\name{otp_get_times}
\alias{otp_get_times}
\title{Finds the time in minutes between supplied origin and destination}
\usage{
otp_get_times(otpcon, fromPlace, toPlace, mode = "CAR", date, time,
  maxWalkDistance = 800, walkReluctance = 2, arriveBy = FALSE,
  transferPenalty = 0, minTransferTime = 0, detail = FALSE)
}
\arguments{
\item{otpcon}{An OTP connection object produced by \code{\link{otp_connect}}.}

\item{fromPlace}{Numeric vector, Latitude/Longitude pair, e.g. `c(53.48805, -2.24258)`}

\item{toPlace}{Numeric vector, Latitude/Longitude pair, e.g. `c(53.36484, -2.27108)`}

\item{mode}{Character vector, mode(s) of travel. Valid values are: TRANSIT, WALK, BICYCLE,
CAR, BUS, RAIL, OR 'c("TRANSIT", "BICYCLE")'. Note that WALK mode is automatically
included for TRANSIT, BUS, and RAIL. TRANSIT will use all available transit modes. Default is CAR.}

\item{date}{Character, must be in the format mm-dd-yyyy. This is the desired date of travel.
Only relevant if \code{mode} includes public transport. Default is current system date.}

\item{time}{Character, must be in the format hh:mm:ss.
If \code{arriveBy} is FALSE (the default) this is the desired departure time, otherwise the
desired arrival time. Only relevant if \code{mode} includes public transport.
Default is current system time.}

\item{maxWalkDistance}{Numeric. The maximum distance (in meters) the user is
willing to walk. Default = 800.}

\item{walkReluctance}{Integer. A multiplier for how bad walking is, compared
to being in transit for equal lengths of time. Default = 2.}

\item{arriveBy}{Logical. Whether trip should depart (FALSE) or arrive (TRUE) at the specified
date and time. Default is FALSE.}

\item{transferPenalty}{Integer. An additional penalty added to boardings after
the first. The value is in OTP's internal weight units, which are roughly equivalent to seconds. Set this to a high
value to discourage transfers. Default is 0.}

\item{minTransferTime}{Integer. The minimum time, in seconds, between successive
trips on different vehicles. This is designed to allow for imperfect schedule
adherence. This is a minimum; transfers over longer distances might use a longer time.
Default is 0.}

\item{detail}{Logical. Default is FALSE.}
}
\value{
Returns a list. First element in the list is \code{errorId}. This is "OK" if
OTP has not returned an error. Otherwise it is the OTP error code. Second element of list
varies:
\itemize{
\item If OTP has returned an error then \code{errorMessage} contains the OTP error message.
\item If there is no error and \code{detail} is FALSE then \code{duration} in minutes is returned as integer.
\item If there is no error and \code{detail} is TRUE then \code{itineraries} as a dataframe.
}
}
\description{
Finds the time in minutes between supplied origin and destination by specified mode(s).
If \code{detail} is set to TRUE returns time for each mode, waiting time and number of transfers.
}
\examples{
\dontrun{
otp_get_times(otpcon, fromPlace = c(53.48805, -2.24258), toPlace = c(53.36484, -2.27108))

otp_get_times(otpcon, fromPlace = c(53.48805, -2.24258), toPlace = c(53.36484, -2.27108),
mode = "BUS", date = "03-26-2019", time = "08:00:00")

otp_get_times(otpcon, fromPlace = c(53.48805, -2.24258), toPlace = c(53.36484, -2.27108),
mode = "BUS", date = "03-26-2019", time = "08:00:00", detail = TRUE)
}
}
