% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/osrmRoute.R
\name{osrmRoute}
\alias{osrmRoute}
\title{Get the Shortest Path Between Two Points}
\usage{
osrmRoute(src, dst, overview = "simplified", sp = FALSE)
}
\arguments{
\item{src}{a numeric vector of identifier, longitude and latitude (WGS84), a 
SpatialPointsDataFrame or a SpatialPolygonsDataFrame of the origine 
point.}

\item{dst}{a numeric vector of identifier, longitude and latitude (WGS84), a 
SpatialPointsDataFrame or a SpatialPolygonsDataFrame of the destination 
point.}

\item{overview}{"full", "simplified" or FALSE. Add geometry either full (detailed), simplified 
according to highest zoom level it could be display on, or not at all.}

\item{sp}{if sp is TRUE the function returns a SpatialLinesDataFrame.}
}
\value{
If sp is FALSE, a data frame is returned. It contains the longitudes and latitudes of 
the travel path between the two points.\cr
If sp is TRUE a SpatialLinesDataFrame is returned. It contains 4 fields : 
identifiers of origine and destination, travel time in minutes and travel distance in 
kilometers.\cr
If overview is FALSE, a named numeric vector is returned. It contains travel time (in minutes) 
and travel distance (in kilometers).
}
\description{
Build and send an OSRM API query to get the travel geometry between two points.
This function interfaces the \emph{route} OSRM service.
}
\examples{
\dontrun{

# Load data
data("com")
# Travel path between points
route <- osrmRoute(src = com[1, c("comm_id", "lon","lat")],
                   dst = com[15, c("comm_id", "lon","lat")])
# Display the path
plot(com[c(1,15),3:4], asp =1, col = "red", pch = 20, cex = 1.5)
points(route[,1:2], type = "l", lty = 2)
text(com[c(1,15),3:4], labels = com[c(1,15),2], pos = 2)

# Travel path between points - output a SpatialLinesDataFrame
route2 <- osrmRoute(src=c("Bethune", 2.64781, 50.5199),
                    dst = c("Cassel", 2.486388, 50.80016),
                    sp = TRUE)
# Display the path
plot(com[c(1,16),3:4], asp =1, col = "red", pch = 20, cex = 1.5)
plot(route2, lty = 2, add=TRUE)
text(com[c(1,16),3:4], labels = com[c(1,16),2], pos = 2)

# Input is SpatialPointsDataFrames
route3 <- osrmRoute(src = src[1,], dst = dst[1,], sp = TRUE)
route3@data
}
}
