% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print-osm-map.R
\name{print_osm_map}
\alias{print_osm_map}
\title{print_osm_map}
\usage{
print_osm_map(map, width, height, filename, device, units = c("in", "cm",
  "mm", "px"), dpi = 300)
}
\arguments{
\item{map}{The map to be printed; a \code{ggplot2} object produced by
\code{osmplotr}.}

\item{width}{Desired width of graphics device.}

\item{height}{Desired height of graphics device. Ignored if width specified.}

\item{filename}{Name of file to which map is to be printed.}

\item{device}{Type of graphics device (extracted from filename extension if
not explicitly provided).}

\item{units}{Units for height and width of graphics device.}

\item{dpi}{Resolution of graphics device (dots-per-inch).}
}
\description{
Prints an OSM map produced with \code{osmplotr} to a specified graphics device.
}
\examples{
bbox <- get_bbox (c (-0.13, 51.5, -0.11, 51.52))
map <- osm_basemap (bbox = bbox, bg = 'gray20')
map <- add_osm_objects (map, london$dat_BNR, col = 'gray40') 
print_osm_map (map, width = 7) # prints to screen device
\dontrun{
print_osm_map (map, file = 'map.png', width = 500, units = 'px')
}
}
\seealso{
\code{\link{osm_basemap}}, \code{\link{add_osm_objects}},
\code{\link{make_osm_map}}.
}
