% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/osm_get_user_details.R
\name{osm_get_user_details}
\alias{osm_get_user_details}
\title{Details of users}
\usage{
osm_get_user_details(user_id, format = c("R", "xml", "json"))
}
\arguments{
\item{user_id}{The ids of the users to retrieve the details for, represented by a numeric or a character value (not
the display names).}

\item{format}{Format of the output. Can be \code{"R"} (default), \code{"xml"}, or \code{"json"}.}
}
\value{
For users not found, the result is empty. If \code{format = "R"}, returns a data frame with one user per row.
\subsection{\code{format = "xml"}}{

Returns a \link[xml2:oldclass]{xml2::xml_document} with the following format:

\if{html}{\out{<div class="sourceCode xml">}}\preformatted{<osm version="0.6" generator="OpenStreetMap server">
	<user id="12023" display_name="jbpbis" account_created="2007-08-16T01:35:56Z">
		<description></description>
		<contributor-terms agreed="false"/>
		<img href="http://www.gravatar.com/avatar/c8c86cd15f60ecca66ce2b10cb6b9a00.jpg?s=256&amp;d=http\%3A\%2F\%2Fwww.openstreetmap.org\%2Fassets\%2Fusers\%2Fimages\%2Flarge-39c3a9dc4e778311af6b70ddcf447b58.png"/>
		<roles>
		</roles>
		<changesets count="1"/>
		<traces count="0"/>
		<blocks>
			<received count="0" active="0"/>
		</blocks>
	</user>
	<user id="210447" display_name="siebh" account_created="2009-12-20T10:11:42Z">
		<description></description>
		<contributor-terms agreed="true"/>
		<roles>
		</roles>
		<changesets count="267"/>
		<traces count="1"/>
		<blocks>
			<received count="0" active="0"/>
		</blocks>
	</user>
</osm>
}\if{html}{\out{</div>}}
}

\subsection{\code{format = "json"}}{

Returns a list with the following json structure:

\if{html}{\out{<div class="sourceCode json">}}\preformatted{\{
 "version": "0.6",
 "generator": "OpenStreetMap server",
 "users": [
  \{"user": \{"id": 12023, "display_name": "jbpbis", "account_created": "2007-08-16T01:35:56Z", "description": "", "contributor_terms": \{"agreed": False\}, "roles": [], "changesets": \{"count": 1\}, "traces": \{"count": 0\}, "blocks": \{"received": \{"count": 0, "active": 0\}\}\}\},
  \{"user": \{"id": 210447, "display_name": "siebh", "account_created": "2009-12-20T10:11:42Z", "description": "", "contributor_terms": \{"agreed": True\}, "roles": [], "changesets": \{"count": 363\}, "traces": \{"count": 1\}, "blocks": \{"received": \{"count": 0, "active": 0\}\}\}\}
 ]
\}
}\if{html}{\out{</div>}}
}
}
\description{
Details of users
}
\examples{
\dontrun{
usrs <- osm_get_user_details(user_id = c(1, 24, 44, 45, 46, 48, 49, 50))
usrs
}
}
\seealso{
Other users' functions: 
\code{\link{osm_details_logged_user}()},
\code{\link{osm_get_preferences_user}()}
}
\concept{users' functions}
