% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ormPredictionplot.R
\name{plot.lrm}
\alias{plot.lrm}
\title{Plot the prediction with confidence intervals}
\usage{
\method{plot}{lrm}(x, ...)
}
\arguments{
\item{x}{an object created by \code{Predict}}

\item{...}{additional parameters that will be passed to \code{\link[rms]{Predict}}}
}
\value{
a \code{ggplot} plot object
}
\description{
This function plots the model predictions given that all variables that are
not included in the plot are kept constant. Hence it requires at least one
variable to produce a plot.
returns a \code{ggplot} object that can be further customized like any
other \code{ggplot}
}
\examples{
#load the libraries
library(rms)
library(ormPlot)

#make the datadist
dd<-datadist(educ_data)
options(datadist='dd')

#create the model
cran_model <- orm(educ_3 ~ Rural + sex + max_SEP_3 + cran_rzs, data = educ_data)

#plot the predictions of the model for varying one variable only
plot(cran_model, cran_rzs)

#customize the plotting varying all variables
plot(cran_model, cran_rzs,
      plot_cols = max_SEP_3,
      plot_rows = c(Rural, sex),

      #setting new x-label (optional)
     xlab = "Cranial volume (residuals to age an birth date)",

     #setting new facet labels (optional)
     facet_labels = list(Rural = c("Urban", "Rural"),
                          sex = c("Boys","Girls"))
     )
}
\seealso{
\code{\link[rms]{Predict}}, \code{\link[rms]{datadist}}, \code{\link[rms]{orm}}
}
