% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zsumlp.R
\name{zsumlp}
\alias{zsumlp}
\alias{zsumlp,loca.p-method}
\alias{zsumlpgra}
\alias{zsumlpgra,loca.p-method}
\title{zsumlp and zsumlpgra at orloca package}
\usage{
zsumlp(o, x = 0, y = 0, p = 2)
}
\arguments{
\item{o}{An object of \code{loca.p} class.}

\item{x}{The x coordinate of the point to be evaluated.}

\item{y}{The y coordinate of the point to be evaluated.}

\item{p}{The \eqn{l_p} norm to use.}

\item{partial}{If (x,y) is a demand point \code{partial=T} means ignore such point to compute the gradient. This option is mainly for internal use.}
}
\value{
\code{zsumlp} returns the objective function of the min-sum location problem with \eqn{l_p} norm, \eqn{\sum_{a_i \in o} w_i d(a_i, (x,y))}, where \eqn{d(a_i, (x,y))} gives the distances between \eqn{a_i} and the point \eqn{(x,y)} using \eqn{l_p} norm.

\code{zsumlpgra} returns the gradient vector of the function \code{zsumlp}.
}
\description{
zsum and zsumgra functions with \eqn{l_p} norm. Mainly for internal use.
}
\details{
If \eqn{p<1} then \eqn{l_p} are not a norm, so only \eqn{p>=1} are valid values.

Since \eqn{l_2} norm is the Euclidean norm, when \eqn{p=2} \code{zsumlp} are equal to \code{zsum}, and \code{zsumlpgra} are equal to \code{zsumgra}.
But the computations involved are greater for the firsts form.
}
\seealso{
See also \code{\link{zsum}}, \code{\link{orloca-package}} and \code{\link{zsumlpmin}}.
}
\keyword{classes}
\keyword{internal}
\keyword{optimize}
