% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nsr.R
\name{nsr}
\alias{nsr}
\title{Search the Native Species Resolver}
\usage{
nsr(species, country, stateprovince = NULL, countyparish = NULL, ...)
}
\arguments{
\item{species}{(character) One or more species names. required.}

\item{country}{(character) A country name. required.}

\item{stateprovince}{(character) A state or province name}

\item{countyparish}{(character) A county or parish name}

\item{...}{Further args passed on to \code{\link[httr]{GET}}}
}
\description{
Search the Native Species Resolver
}
\details{
Currently, only one name is allowed per request. We loop internally
over a list of length > 1, but this will still be slow due to only 1
name per request.

Note that this service can be quite slow.
}
\examples{
\dontrun{
nsr("Pinus ponderosa", "United States")
nsr(c("Pinus ponderosa", "Poa annua"), "United States")
splist <- c("Pinus ponderosa", "Poa annua", "bromus tectorum", "Ailanthus altissima")
nsr(splist, country = "United States")

# curl options
library("httr")
nsr("Pinus ponderosa", "United States", config = verbose())
}
}
\references{
\url{http://bien.nceas.ucsb.edu/bien/tools/nsr/nsr-ws/}
}

