% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/orf_user.R
\name{summary.orf}
\alias{summary.orf}
\title{Summary of the Ordered Forest}
\usage{
\method{summary}{orf}(object, latex = FALSE, ...)
}
\arguments{
\item{object}{estimated Ordered Forest object of class \code{orf}}

\item{latex}{logical, if TRUE latex coded summary will be generated (default is FALSE)}

\item{...}{further arguments (currently ignored)}
}
\description{
summary of an estimated Ordered Forest object of class \code{orf}
}
\details{
\code{summary.orf} provides a short summary of the Ordered Forest estimation,
including the input information regarding the values of hyperparameters as
well as the output information regarding the prediction accuracy.
}
\examples{
# Ordered Forest
require(orf)

# load example data
data(odata)

# specify response and covariates
Y <- as.numeric(odata[, 1])
X <- as.matrix(odata[, -1])

# estimate Ordered Forest
orf_fit <- orf(X, Y)

# show summary of the orf estimation
summary(orf_fit)

# show summary of the orf estimation coded in LaTeX
summary(orf_fit, latex = TRUE)

}
\author{
Gabriel Okasa
}
