% Generated by roxygen2 (4.0.2): do not edit by hand
\name{ore.subst}
\alias{ore.subst}
\title{Replace matched substrings with new text}
\usage{
ore.subst(regex, replacement, text, ..., all = FALSE)
}
\arguments{
\item{regex}{A single character string or object of class \code{"ore"}. In
the former case, this will first be passed through \code{\link{ore}}.}

\item{replacement}{A single character string, or a function to be applied
to the matches.}

\item{text}{A vector of strings to match against.}

\item{...}{Further arguments to \code{replacement}, if it is a function.}

\item{all}{If \code{TRUE}, then all matches within each element of
\code{text} will be found. Otherwise, the search will stop at the first
match.}
}
\value{
A version of \code{text} with the substitutions made.
}
\description{
This function substitutes new text into strings in regions that match a
regular expression. The substitutions may be simple text, may include
references to matched subgroups, or may be created by an R function.
}
\examples{
# Simple text substitution (produces "no dogs")
ore.subst("\\\\d+", "no", "2 dogs")

# Back-referenced substitution (produces "22 dogs")
ore.subst("(\\\\d+)", "\\\\1\\\\1", "2 dogs")

# Function-based substitution (produces "4 dogs")
ore.subst("\\\\d+", function(i) as.numeric(i)^2, "2 dogs")
}
\seealso{
\code{\link{ore.search}}
}

