% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{orderly_use_resource}
\alias{orderly_use_resource}
\alias{orderly_use_source}
\alias{orderly_use_package}
\alias{orderly_use_gitignore}
\title{Add a resource to orderly.yml}
\usage{
orderly_use_resource(
  resources,
  name = NULL,
  root = NULL,
  locate = TRUE,
  show = TRUE,
  edit = TRUE,
  prompt = TRUE
)

orderly_use_source(
  sources,
  name = NULL,
  root = NULL,
  locate = TRUE,
  show = TRUE,
  edit = TRUE,
  prompt = TRUE
)

orderly_use_package(
  packages,
  name = NULL,
  root = NULL,
  locate = TRUE,
  show = TRUE,
  edit = TRUE,
  prompt = TRUE
)

orderly_use_gitignore(
  root = NULL,
  locate = TRUE,
  show = TRUE,
  edit = TRUE,
  prompt = TRUE
)
}
\arguments{
\item{resources, sources}{Character vector of resources or sources
to add.  These must be filenames relative to the report
directory, must exist, and must not already be present in the
orderly.yml}

\item{name}{Name of the report to modify.  Like
\code{\link[=orderly_develop_start]{orderly_develop_start()}} this can be \code{NULL} if
you have already set the working directory to be the source
directory.}

\item{root}{The path to an orderly root directory, or \code{NULL}
(the default) to search for one from the current working
directory if \code{locate} is \code{TRUE}.}

\item{locate}{Logical, indicating if the configuration should be
searched for.  If \code{TRUE} and \code{config} is not given,
then orderly looks in the working directory and up through its
parents until it finds an \code{orderly_config.yml} file.}

\item{show}{Logical, indicating if we should print the proposed
changes to screen}

\item{edit}{Logical, indicating if we should actually edit the
\code{orderly.yml} file.}

\item{prompt}{Logical, indicating if we should prompt before
editing the orderly.yml file.  Only has an effect if \code{edit}
is \code{TRUE}.}

\item{packages}{Character vector of package names to add.  These
must not already exist in the orderly.yml}
}
\value{
Invisibly, this function returns information about the
file it would edit.  This information is primarily for debugging
purposes and the format is subject to change.
}
\description{
Add one or more resources to an \code{orderly.yml} file.
}
\details{
The \code{orderly_use_gitignore} configures a basic
\code{.gitignore} file at the root of your orderly project that
will prevent files from being added to git.  This is only really
useful if you are using (or will use) git, but it is harmless at
worst.
}
\examples{
path <- orderly::orderly_example("minimal")

# Suppose we wanted to use the mtcars data within our report.
# First, the file must exist:
write.csv(mtcars, file.path(path, "src", "example", "mtcars.csv"),
          row.names = FALSE)

# Preview expected changes
orderly::orderly_use_resource("mtcars.csv", "example", path, edit = FALSE)

# Modify the orderly.yml file within src/example:
orderly::orderly_use_resource("mtcars.csv", "example", path, prompt = FALSE)

# The result is a file that now has a 'resources' section
# containing our new file
writeLines(readLines(file.path(path, "src", "example", "orderly.yml")))

# (of course, we'd still need to modify the script to use it).
}
