% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InfinitySparseMatrix.R
\name{sort.InfinitySparseMatrix}
\alias{sort.InfinitySparseMatrix}
\alias{sort.BlockedInfinitySparseMatrix}
\title{Sort the internal structure of an InfinitySparseMatrix.}
\usage{
\method{sort}{InfinitySparseMatrix}(x, decreasing = FALSE, ...,
  byCol = FALSE)

\method{sort}{BlockedInfinitySparseMatrix}(x, decreasing = FALSE, ...,
  byCol = FALSE)
}
\arguments{
\item{x}{An InfinitySparseMatrix or BlockedInfinitySparseMatrix.}

\item{decreasing}{Logical. Should the sort be increasing or
decreasing?}

\item{...}{Additional arguments ignored.}

\item{byCol}{Logical. Defaults to FALSE, so the returned ISM is
row-dominant. TRUE returns a column-dominant ISM.}
}
\value{
An object of the same class as `x` which is sorted
  according to `byCol`.
}
\description{
Internally, an InfinitySparseMatrix (Blocked or non) comprises of
vectors of values, row positions, and column positions. The
ordering of these vectors is not enforced. This function sorts the
internal structure, leaving the external structure unchanged
(e.g. `as.matrix(ism)` and `as.matrix(sort(ism))` will look
identical despite sorting.)
}
\details{
By default, the InfinitySparseMatrix is row-dominant, meaning the
row positions are sorted first, then column positions are sorted
within each row. Use argument `byCol` to change this.
}
