% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/options_env.R
\name{options_env}
\alias{options_env}
\alias{get_options_env}
\alias{options_initialized}
\alias{init_options_env}
\alias{get_option_default_value}
\alias{get_options_spec}
\alias{get_option_spec}
\alias{set_option_spec}
\title{Options Environment Class}
\usage{
get_options_env(env, ...)

options_initialized(env, inherits = FALSE)

init_options_env(env = parent.frame())

get_option_default_value(x, env = parent.frame())

get_options_spec(env = parent.frame())

get_option_spec(name, env = parent.frame())

set_option_spec(name, details, env = parent.frame())
}
\arguments{
\item{env}{An environment in which to search for an options environment}

\item{...}{Additional arguments unused}

\item{inherits}{Whether to search upward through parent environments}
}
\description{
The options environment stores primarily, the default values for options. In
addition, it stores metadata pertaining to each option in the form of
attributes.
}
\section{Functions}{
\itemize{
\item \code{get_options_env()}: Initialize (if needed) and retrieve an environment containing options

\item \code{options_initialized()}: Test whether options is initialized in environment

\item \code{init_options_env()}: Initialize an options object

\item \code{get_option_default_value()}: Get the option's default value

\item \code{get_options_spec()}: Get all options specifications as named list

\item \code{get_option_spec()}: Get single option specification

\item \code{set_option_spec()}: Set single option specification

}}
\section{Attributes}{

\itemize{
\item \code{spec}: A named list of option specifications
\item \code{option_name_fn}: A function used to derive default option names for
newly defined options. See \code{\link[=set_option_name_fn]{set_option_name_fn()}}.
\item \code{envvar_name_fn}: A function used to derive default environment variable
names for newly defined options. See \code{\link[=set_envvar_name_fn]{set_envvar_name_fn()}}.
}
}

\concept{options_env}
\keyword{internal}
