% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcNetIncome.R
\name{calcNetIncome}
\alias{calcNetIncome}
\title{Calculate income after tax and benefits}
\usage{
calcNetIncome(persons = data.table(personID = 1:2, householdID = 1,
  employedIncome = c(15000, 40000), investmentIncome = c(0, 5000),
  nonTaxableIncome = 0, selfEmployedProfits = 0, taxCode = "1000L",
  numberOfChildren = 1, salarySacrificePercentage = c(0, 0.05), studentLoan =
  0:1), incomeGrain = "Month", financialYear = taxYear(Sys.Date()),
  modelArgs = list(model = FALSE, inflation = 1, years = 3, childBenefitChange
  = 1, personalAllowanceChange = 500),
  thresholdsTable = fread(system.file("extdata", "annualthresholds.csv",
  package = "optiRum")), taxRateTable = fread(system.file("extdata",
  "annualtaxthresholds.csv", package = "optiRum")))
}
\arguments{
\item{persons}{Provide the information required for calculating income,
values should be provided as annual incomes}

\item{incomeGrain}{Define the time period in which the income return
should be expressed i.e. "Annual", "Month", "Week"}

\item{financialYear}{What financial year the calculation should be performed for.
Can't go back further than 2014, if you need to go back please
submit a pull request on the CSVs in inst/extdata with them filled in.}

\item{modelArgs}{Indicate whether a forward prediction with some 
changing values should be performed, and what scenario values should be
used}

\item{thresholdsTable}{The values needed for calculating various components}

\item{taxRateTable}{The values needed for calculating Income Tax and NI (Class 1 and 4).
Rate tables contain lower bound (LB), upper bound (UB) 
and the prevailing tax rates (Rate) at which portions of 
income are taxed at. LB >= Income < UB}
}
\value{
income                    Income components for each person at the relevant grain
}
\description{
Based on current UK taxation rules this function 
calculates components that subtract from gross income
and provides net income.
}
\details{
Current, in the context of default values, is Tax Year 2014
}
\seealso{
Other tax: \code{\link{taxYear}}
}
\keyword{financial}
\keyword{income}
\keyword{tax}

