% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-workbook-wrappers.R
\name{wb_add_page_break}
\alias{wb_add_page_break}
\title{Add a page break to a worksheet}
\usage{
wb_add_page_break(wb, sheet = current_sheet(), row = NULL, col = NULL)
}
\arguments{
\item{wb}{A workbook object}

\item{sheet}{A name or index of a worksheet}

\item{row, col}{Either a row number of column number.  One must be \code{NULL}}
}
\description{
Insert page breaks into a worksheet
}
\examples{
wb <- wb_workbook()
wb$add_worksheet("Sheet 1")
wb$add_data(sheet = 1, x = iris)

wb$add_page_break(sheet = 1, row = 10)
wb$add_page_break(sheet = 1, row = 20)
wb$add_page_break(sheet = 1, col = 2)
}
\seealso{
\code{\link[=wb_add_worksheet]{wb_add_worksheet()}}
}
