% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-workbook-wrappers.R
\name{wb_add_image}
\alias{wb_add_image}
\title{Insert an image into a worksheet}
\usage{
wb_add_image(
  wb,
  sheet = current_sheet(),
  dims = "A1",
  file,
  width = 6,
  height = 3,
  row_offset = 0,
  col_offset = 0,
  units = "in",
  dpi = 300,
  ...
)
}
\arguments{
\item{wb}{A workbook object}

\item{sheet}{A name or index of a worksheet}

\item{dims}{Dimensions where to plot. Default absolute anchor, single cell (eg. "A1") oneCellAnchor, cell range (eg. "A1:D4") twoCellAnchor}

\item{file}{An image file. Valid file types are:\code{ "jpeg"}, \code{"png"}, \code{"bmp"}}

\item{width}{Width of figure.}

\item{height}{Height of figure.}

\item{row_offset}{offset vector for one or two cell anchor within cell (row)}

\item{col_offset}{offset vector for one or two cell anchor within cell (column)}

\item{units}{Units of width and height. Can be \code{"in"}, \code{"cm"} or \code{"px"}}

\item{dpi}{Image resolution used for conversion between units.}

\item{...}{additional arguments}
}
\description{
Insert an image into a worksheet
}
\examples{
img <- system.file("extdata", "einstein.jpg", package = "openxlsx2")

wb <- wb_workbook()$
  add_worksheet()$
  add_image("Sheet 1", dims = "C5", file = img, width = 6, height = 5)$
  add_worksheet()$
  add_image(dims = "B2", file = img)$
  add_worksheet()$
  add_image(dims = "G3", file = img, width = 15, height = 12, units = "cm")
}
\seealso{
\code{\link[=wb_add_chart_xml]{wb_add_chart_xml()}} \code{\link[=wb_add_drawing]{wb_add_drawing()}} \code{\link[=wb_add_mschart]{wb_add_mschart()}} \code{\link[=wb_add_plot]{wb_add_plot()}}
}
