% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/CommentClass.R
\name{createComment}
\alias{createComment}
\title{write a cell comment}
\usage{
createComment(comment, author = Sys.getenv("USERNAME"), style = NULL,
  visible = TRUE, width = 2, height = 4)
}
\arguments{
\item{comment}{Comment text. Character vector of length 1}

\item{author}{Author of comment. Character vector of length 1}

\item{style}{A Style object. See \code{\link{createStyle}}.}

\item{visible}{TRUE or FALSE. Is comment visible.}

\item{width}{Textbox integer width in number of cells}

\item{height}{Textbox integer height in number of cells}
}
\description{
write a cell comment
}
\examples{
wb <- createWorkbook()
addWorksheet(wb, "Sheet 1")

c1 <- createComment(comment = "this is comment")
writeComment(wb, 1, col = "B", row = 10, comment = c1)

s1 <- createStyle(fontSize = 12, fontColour = "red", textDecoration = c("BOLD"))
s2 <- createStyle(fontSize = 9, fontColour = "black")

c2 <- createComment(comment = c("This Part Bold red\\n\\n", "This part black"), style = c(s1, s2))
c2

writeComment(wb, 1, col = 6 , row = 3, comment = c2)

saveWorkbook(wb, file = "createCommentExample.xlsx", overwrite = TRUE)
}
\seealso{
\code{\link{writeComment}}
}

