% Generated by roxygen2 (4.0.1): do not edit by hand
\name{readWorkbook}
\alias{readWorkbook}
\title{Read data from a worksheet into a data.frame}
\usage{
readWorkbook(xlsxFile, sheet = 1, startRow = 1, colNames = TRUE,
  skipEmptyRows = TRUE)
}
\arguments{
\item{xlsxFile}{An xlsx file}

\item{sheet}{The name or index of the sheet to read data}

\item{startRow}{first row to begin looking for data.  Empty rows before any data is found are skipped.
regardless of the value of startRow.}

\item{colNames}{If TRUE, first row of data will be used as column names.}

\item{skipEmptyRows}{If TRUE, empty rows are skipped else empty rows after the first row containing data
will return a row of NAs}
}
\value{
data.frame
}
\description{
Read data from a worksheet into a data.frame
}
\details{
Creates a data.frame of all data in worksheet.
}
\examples{
xlsxFile <- system.file("readTest.xlsx", package = "openxlsx")
df1 <- readWorkbook(xlsxFile = xlsxFile, sheet = 1)
}
\author{
Alexander Walker
}
\seealso{
\code{\link{read.xlsx}}
}

