% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/rand_bytes.R
\name{rand_bytes}
\alias{pseudo_rand_bytes}
\alias{rand_bytes}
\alias{rand_num}
\title{Generate random bytes and numbers with OpenSSL}
\usage{
rand_bytes(n = 1)

pseudo_rand_bytes(n = 1)

rand_num(n = 1)
}
\arguments{
\item{n}{number of random bytes or numbers to generate}
}
\description{
this set of functions generates random bytes or numbers from OpenSSL. This
provides a cryptographically secure alternative to R's default random number generator.
\code{rand_bytes} generates \code{n} random, cryptographically secure bytes, while
\code{pseudo_rand_bytes} generates \code{n} pseudo-random bytes, with no guarantee
of cryptographic security. \code{rand_num} uses \code{rand_bytes} to generate cryptographically
secure random numbers, rather than bytes.
}
\examples{
rnd <- rand_bytes(10)
as.numeric(rnd)
as.character(rnd)
as.logical(rawToBits(rnd))

# bytes range from 0 to 255
rnd <- rand_bytes(100000)
hist(as.numeric(rnd), breaks=-1:255)

# Generate random doubles between 0 and 1
rand_num(5)

# Use CDF to map [0,1] into random draws from a distribution
x <- qnorm(rand_num(1000), mean=100, sd=15)
hist(x)

y <- qbinom(rand_num(1000), size=10, prob=0.3)
hist(y)
}
\references{
OpenSSL manual: \url{https://www.openssl.org/docs/crypto/RAND_bytes.html}
}

